/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.transform.QueryExecutionStatisticsMarshaller;
import java.io.Serializable;

public class QueryExecutionStatistics
implements Serializable,
Cloneable,
StructuredPojo {
    private Long engineExecutionTimeInMillis;
    private Long dataScannedInBytes;

    public void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
        this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
    }

    public Long getEngineExecutionTimeInMillis() {
        return this.engineExecutionTimeInMillis;
    }

    public QueryExecutionStatistics withEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
        this.setEngineExecutionTimeInMillis(engineExecutionTimeInMillis);
        return this;
    }

    public void setDataScannedInBytes(Long dataScannedInBytes) {
        this.dataScannedInBytes = dataScannedInBytes;
    }

    public Long getDataScannedInBytes() {
        return this.dataScannedInBytes;
    }

    public QueryExecutionStatistics withDataScannedInBytes(Long dataScannedInBytes) {
        this.setDataScannedInBytes(dataScannedInBytes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngineExecutionTimeInMillis() != null) {
            sb.append("EngineExecutionTimeInMillis: ").append(this.getEngineExecutionTimeInMillis()).append(",");
        }
        if (this.getDataScannedInBytes() != null) {
            sb.append("DataScannedInBytes: ").append(this.getDataScannedInBytes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics)obj;
        if (other.getEngineExecutionTimeInMillis() == null ^ this.getEngineExecutionTimeInMillis() == null) {
            return false;
        }
        if (other.getEngineExecutionTimeInMillis() != null && !other.getEngineExecutionTimeInMillis().equals(this.getEngineExecutionTimeInMillis())) {
            return false;
        }
        if (other.getDataScannedInBytes() == null ^ this.getDataScannedInBytes() == null) {
            return false;
        }
        return other.getDataScannedInBytes() == null || other.getDataScannedInBytes().equals(this.getDataScannedInBytes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngineExecutionTimeInMillis() == null ? 0 : this.getEngineExecutionTimeInMillis().hashCode());
        hashCode = 31 * hashCode + (this.getDataScannedInBytes() == null ? 0 : this.getDataScannedInBytes().hashCode());
        return hashCode;
    }

    public QueryExecutionStatistics clone() {
        try {
            return (QueryExecutionStatistics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

