/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteStackRequestMarshaller
implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {
    @Override
    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {
        SdkInternalList retainResourcesList;
        if (deleteStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteStackRequest> request = new DefaultRequest<DeleteStackRequest>(deleteStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(deleteStackRequest.getStackName()));
        }
        if ((retainResourcesList = (SdkInternalList)deleteStackRequest.getRetainResources()).isEmpty() && !retainResourcesList.isAutoConstruct()) {
            request.addParameter("RetainResources", "");
        }
        if (!retainResourcesList.isEmpty() || !retainResourcesList.isAutoConstruct()) {
            int retainResourcesListIndex = 1;
            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex, StringUtils.fromString(retainResourcesListValue));
                }
                ++retainResourcesListIndex;
            }
        }
        if (deleteStackRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(deleteStackRequest.getRoleARN()));
        }
        if (deleteStackRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(deleteStackRequest.getClientRequestToken()));
        }
        return request;
    }
}

