/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.Hsm;

@SdkInternalApi
public class HsmMarshaller {
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> ENIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniId").build();
    private static final MarshallingInfo<String> ENIIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniIp").build();
    private static final MarshallingInfo<String> HSMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateMessage").build();
    private static final HsmMarshaller instance = new HsmMarshaller();

    public static HsmMarshaller getInstance() {
        return instance;
    }

    public void marshall(Hsm hsm, ProtocolMarshaller protocolMarshaller) {
        if (hsm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hsm.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(hsm.getClusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall(hsm.getSubnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(hsm.getEniId(), ENIID_BINDING);
            protocolMarshaller.marshall(hsm.getEniIp(), ENIIP_BINDING);
            protocolMarshaller.marshall(hsm.getHsmId(), HSMID_BINDING);
            protocolMarshaller.marshall(hsm.getState(), STATE_BINDING);
            protocolMarshaller.marshall(hsm.getStateMessage(), STATEMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

