/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchv2.model.ScalingParameters;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateScalingParametersRequestMarshaller
implements Marshaller<Request<UpdateScalingParametersRequest>, UpdateScalingParametersRequest> {
    @Override
    public Request<UpdateScalingParametersRequest> marshall(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ScalingParameters scalingParameters;
        if (updateScalingParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateScalingParametersRequest> request = new DefaultRequest<UpdateScalingParametersRequest>(updateScalingParametersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "UpdateScalingParameters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateScalingParametersRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(updateScalingParametersRequest.getDomainName()));
        }
        if ((scalingParameters = updateScalingParametersRequest.getScalingParameters()) != null) {
            if (scalingParameters.getDesiredInstanceType() != null) {
                request.addParameter("ScalingParameters.DesiredInstanceType", StringUtils.fromString(scalingParameters.getDesiredInstanceType()));
            }
            if (scalingParameters.getDesiredReplicationCount() != null) {
                request.addParameter("ScalingParameters.DesiredReplicationCount", StringUtils.fromInteger(scalingParameters.getDesiredReplicationCount()));
            }
            if (scalingParameters.getDesiredPartitionCount() != null) {
                request.addParameter("ScalingParameters.DesiredPartitionCount", StringUtils.fromInteger(scalingParameters.getDesiredPartitionCount()));
            }
        }
        return request;
    }
}

