/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.JobData;
import java.util.List;

@SdkInternalApi
public class JobDataMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACTIONTYPEID_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionTypeId").build();
    private static final MarshallingInfo<StructuredPojo> ACTIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> PIPELINECONTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineContext").build();
    private static final MarshallingInfo<List> INPUTARTIFACTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputArtifacts").build();
    private static final MarshallingInfo<List> OUTPUTARTIFACTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputArtifacts").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTCREDENTIALS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactCredentials").build();
    private static final MarshallingInfo<String> CONTINUATIONTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("continuationToken").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionKey").build();
    private static final JobDataMarshaller instance = new JobDataMarshaller();

    public static JobDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(JobData jobData, ProtocolMarshaller protocolMarshaller) {
        if (jobData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(jobData.getActionTypeId(), ACTIONTYPEID_BINDING);
            protocolMarshaller.marshall(jobData.getActionConfiguration(), ACTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(jobData.getPipelineContext(), PIPELINECONTEXT_BINDING);
            protocolMarshaller.marshall(jobData.getInputArtifacts(), INPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall(jobData.getOutputArtifacts(), OUTPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall(jobData.getArtifactCredentials(), ARTIFACTCREDENTIALS_BINDING);
            protocolMarshaller.marshall(jobData.getContinuationToken(), CONTINUATIONTOKEN_BINDING);
            protocolMarshaller.marshall(jobData.getEncryptionKey(), ENCRYPTIONKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

