/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cognitoidp.model.ContextDataType;
import java.util.List;

@SdkInternalApi
public class ContextDataTypeMarshaller {
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").build();
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").build();
    private static final MarshallingInfo<String> SERVERPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerPath").build();
    private static final MarshallingInfo<List> HTTPHEADERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpHeaders").build();
    private static final MarshallingInfo<String> ENCODEDDATA_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncodedData").build();
    private static final ContextDataTypeMarshaller instance = new ContextDataTypeMarshaller();

    public static ContextDataTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContextDataType contextDataType, ProtocolMarshaller protocolMarshaller) {
        if (contextDataType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(contextDataType.getIpAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall(contextDataType.getServerName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall(contextDataType.getServerPath(), SERVERPATH_BINDING);
            protocolMarshaller.marshall(contextDataType.getHttpHeaders(), HTTPHEADERS_BINDING);
            protocolMarshaller.marshall(contextDataType.getEncodedData(), ENCODEDDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

