/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cognitoidp.model.HttpHeader;

@SdkInternalApi
public class HttpHeaderMarshaller {
    private static final MarshallingInfo<String> HEADERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("headerName").build();
    private static final MarshallingInfo<String> HEADERVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("headerValue").build();
    private static final HttpHeaderMarshaller instance = new HttpHeaderMarshaller();

    public static HttpHeaderMarshaller getInstance() {
        return instance;
    }

    public void marshall(HttpHeader httpHeader, ProtocolMarshaller protocolMarshaller) {
        if (httpHeader == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(httpHeader.getHeaderName(), HEADERNAME_BINDING);
            protocolMarshaller.marshall(httpHeader.getHeaderValue(), HEADERVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

