/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.databasemigrationservice.model.TableToReload;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReloadTablesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String replicationTaskArn;
    private List<TableToReload> tablesToReload;

    public void setReplicationTaskArn(String replicationTaskArn) {
        this.replicationTaskArn = replicationTaskArn;
    }

    public String getReplicationTaskArn() {
        return this.replicationTaskArn;
    }

    public ReloadTablesRequest withReplicationTaskArn(String replicationTaskArn) {
        this.setReplicationTaskArn(replicationTaskArn);
        return this;
    }

    public List<TableToReload> getTablesToReload() {
        return this.tablesToReload;
    }

    public void setTablesToReload(Collection<TableToReload> tablesToReload) {
        if (tablesToReload == null) {
            this.tablesToReload = null;
            return;
        }
        this.tablesToReload = new ArrayList<TableToReload>(tablesToReload);
    }

    public ReloadTablesRequest withTablesToReload(TableToReload ... tablesToReload) {
        if (this.tablesToReload == null) {
            this.setTablesToReload(new ArrayList<TableToReload>(tablesToReload.length));
        }
        for (TableToReload ele : tablesToReload) {
            this.tablesToReload.add(ele);
        }
        return this;
    }

    public ReloadTablesRequest withTablesToReload(Collection<TableToReload> tablesToReload) {
        this.setTablesToReload(tablesToReload);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationTaskArn() != null) {
            sb.append("ReplicationTaskArn: ").append(this.getReplicationTaskArn()).append(",");
        }
        if (this.getTablesToReload() != null) {
            sb.append("TablesToReload: ").append(this.getTablesToReload());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadTablesRequest)) {
            return false;
        }
        ReloadTablesRequest other = (ReloadTablesRequest)obj;
        if (other.getReplicationTaskArn() == null ^ this.getReplicationTaskArn() == null) {
            return false;
        }
        if (other.getReplicationTaskArn() != null && !other.getReplicationTaskArn().equals(this.getReplicationTaskArn())) {
            return false;
        }
        if (other.getTablesToReload() == null ^ this.getTablesToReload() == null) {
            return false;
        }
        return other.getTablesToReload() == null || other.getTablesToReload().equals(this.getTablesToReload());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationTaskArn() == null ? 0 : this.getReplicationTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getTablesToReload() == null ? 0 : this.getTablesToReload().hashCode());
        return hashCode;
    }

    @Override
    public ReloadTablesRequest clone() {
        return (ReloadTablesRequest)super.clone();
    }
}

