/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ReleaseHostsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ReleaseHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ReleaseHostsRequest> {
    private SdkInternalList<String> hostIds;

    public List<String> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new SdkInternalList();
        }
        return this.hostIds;
    }

    public void setHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
            return;
        }
        this.hostIds = new SdkInternalList<String>(hostIds);
    }

    public ReleaseHostsRequest withHostIds(String ... hostIds) {
        if (this.hostIds == null) {
            this.setHostIds(new SdkInternalList<String>(hostIds.length));
        }
        for (String ele : hostIds) {
            this.hostIds.add(ele);
        }
        return this;
    }

    public ReleaseHostsRequest withHostIds(Collection<String> hostIds) {
        this.setHostIds(hostIds);
        return this;
    }

    @Override
    public Request<ReleaseHostsRequest> getDryRunRequest() {
        Request<ReleaseHostsRequest> request = new ReleaseHostsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostIds() != null) {
            sb.append("HostIds: ").append(this.getHostIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseHostsRequest)) {
            return false;
        }
        ReleaseHostsRequest other = (ReleaseHostsRequest)obj;
        if (other.getHostIds() == null ^ this.getHostIds() == null) {
            return false;
        }
        return other.getHostIds() == null || other.getHostIds().equals(this.getHostIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostIds() == null ? 0 : this.getHostIds().hashCode());
        return hashCode;
    }

    @Override
    public ReleaseHostsRequest clone() {
        return (ReleaseHostsRequest)super.clone();
    }
}

