/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeElasticGpusRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeElasticGpusRequestMarshaller
implements Marshaller<Request<DescribeElasticGpusRequest>, DescribeElasticGpusRequest> {
    @Override
    public Request<DescribeElasticGpusRequest> marshall(DescribeElasticGpusRequest describeElasticGpusRequest) {
        SdkInternalList describeElasticGpusRequestFiltersList;
        if (describeElasticGpusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeElasticGpusRequest> request = new DefaultRequest<DescribeElasticGpusRequest>(describeElasticGpusRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeElasticGpus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeElasticGpusRequestElasticGpuIdsList = (SdkInternalList)describeElasticGpusRequest.getElasticGpuIds();
        if (!describeElasticGpusRequestElasticGpuIdsList.isEmpty() || !describeElasticGpusRequestElasticGpuIdsList.isAutoConstruct()) {
            int elasticGpuIdsListIndex = 1;
            for (String describeElasticGpusRequestElasticGpuIdsListValue : describeElasticGpusRequestElasticGpuIdsList) {
                if (describeElasticGpusRequestElasticGpuIdsListValue != null) {
                    request.addParameter("ElasticGpuId." + elasticGpuIdsListIndex, StringUtils.fromString(describeElasticGpusRequestElasticGpuIdsListValue));
                }
                ++elasticGpuIdsListIndex;
            }
        }
        if (!(describeElasticGpusRequestFiltersList = (SdkInternalList)describeElasticGpusRequest.getFilters()).isEmpty() || !describeElasticGpusRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeElasticGpusRequestFiltersListValue : describeElasticGpusRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeElasticGpusRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeElasticGpusRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeElasticGpusRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeElasticGpusRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeElasticGpusRequest.getMaxResults()));
        }
        if (describeElasticGpusRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeElasticGpusRequest.getNextToken()));
        }
        return request;
    }
}

