/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePlacementGroupsRequestMarshaller
implements Marshaller<Request<DescribePlacementGroupsRequest>, DescribePlacementGroupsRequest> {
    @Override
    public Request<DescribePlacementGroupsRequest> marshall(DescribePlacementGroupsRequest describePlacementGroupsRequest) {
        SdkInternalList describePlacementGroupsRequestGroupNamesList;
        if (describePlacementGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribePlacementGroupsRequest> request = new DefaultRequest<DescribePlacementGroupsRequest>(describePlacementGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribePlacementGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describePlacementGroupsRequestFiltersList = (SdkInternalList)describePlacementGroupsRequest.getFilters();
        if (!describePlacementGroupsRequestFiltersList.isEmpty() || !describePlacementGroupsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describePlacementGroupsRequestFiltersListValue : describePlacementGroupsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describePlacementGroupsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describePlacementGroupsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describePlacementGroupsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describePlacementGroupsRequestGroupNamesList = (SdkInternalList)describePlacementGroupsRequest.getGroupNames()).isEmpty() || !describePlacementGroupsRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describePlacementGroupsRequestGroupNamesListValue : describePlacementGroupsRequestGroupNamesList) {
                if (describePlacementGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString(describePlacementGroupsRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        return request;
    }
}

