/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RebootCacheClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cacheClusterId;
    private SdkInternalList<String> cacheNodeIdsToReboot;

    public RebootCacheClusterRequest() {
    }

    public RebootCacheClusterRequest(String cacheClusterId, List<String> cacheNodeIdsToReboot) {
        this.setCacheClusterId(cacheClusterId);
        this.setCacheNodeIdsToReboot(cacheNodeIdsToReboot);
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public RebootCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.setCacheClusterId(cacheClusterId);
        return this;
    }

    public List<String> getCacheNodeIdsToReboot() {
        if (this.cacheNodeIdsToReboot == null) {
            this.cacheNodeIdsToReboot = new SdkInternalList();
        }
        return this.cacheNodeIdsToReboot;
    }

    public void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
        if (cacheNodeIdsToReboot == null) {
            this.cacheNodeIdsToReboot = null;
            return;
        }
        this.cacheNodeIdsToReboot = new SdkInternalList<String>(cacheNodeIdsToReboot);
    }

    public RebootCacheClusterRequest withCacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
        if (this.cacheNodeIdsToReboot == null) {
            this.setCacheNodeIdsToReboot(new SdkInternalList<String>(cacheNodeIdsToReboot.length));
        }
        for (String ele : cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot.add(ele);
        }
        return this;
    }

    public RebootCacheClusterRequest withCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
        this.setCacheNodeIdsToReboot(cacheNodeIdsToReboot);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.getCacheClusterId()).append(",");
        }
        if (this.getCacheNodeIdsToReboot() != null) {
            sb.append("CacheNodeIdsToReboot: ").append(this.getCacheNodeIdsToReboot());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootCacheClusterRequest)) {
            return false;
        }
        RebootCacheClusterRequest other = (RebootCacheClusterRequest)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getCacheNodeIdsToReboot() == null ^ this.getCacheNodeIdsToReboot() == null) {
            return false;
        }
        return other.getCacheNodeIdsToReboot() == null || other.getCacheNodeIdsToReboot().equals(this.getCacheNodeIdsToReboot());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeIdsToReboot() == null ? 0 : this.getCacheNodeIdsToReboot().hashCode());
        return hashCode;
    }

    @Override
    public RebootCacheClusterRequest clone() {
        return (RebootCacheClusterRequest)super.clone();
    }
}

