/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCacheClustersRequestMarshaller
implements Marshaller<Request<DescribeCacheClustersRequest>, DescribeCacheClustersRequest> {
    @Override
    public Request<DescribeCacheClustersRequest> marshall(DescribeCacheClustersRequest describeCacheClustersRequest) {
        if (describeCacheClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCacheClustersRequest> request = new DefaultRequest<DescribeCacheClustersRequest>(describeCacheClustersRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeCacheClusters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheClustersRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString(describeCacheClustersRequest.getCacheClusterId()));
        }
        if (describeCacheClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeCacheClustersRequest.getMaxRecords()));
        }
        if (describeCacheClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeCacheClustersRequest.getMarker()));
        }
        if (describeCacheClustersRequest.getShowCacheNodeInfo() != null) {
            request.addParameter("ShowCacheNodeInfo", StringUtils.fromBoolean(describeCacheClustersRequest.getShowCacheNodeInfo()));
        }
        if (describeCacheClustersRequest.getShowCacheClustersNotInReplicationGroups() != null) {
            request.addParameter("ShowCacheClustersNotInReplicationGroups", StringUtils.fromBoolean(describeCacheClustersRequest.getShowCacheClustersNotInReplicationGroups()));
        }
        return request;
    }
}

