/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateConfigurationTemplateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String templateName;
    private String description;
    private SdkInternalList<ConfigurationOptionSetting> optionSettings;
    private SdkInternalList<OptionSpecification> optionsToRemove;

    public UpdateConfigurationTemplateRequest() {
    }

    public UpdateConfigurationTemplateRequest(String applicationName, String templateName) {
        this.setApplicationName(applicationName);
        this.setTemplateName(templateName);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public UpdateConfigurationTemplateRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public UpdateConfigurationTemplateRequest withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateConfigurationTemplateRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new SdkInternalList();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        this.optionSettings = new SdkInternalList<ConfigurationOptionSetting>(optionSettings);
    }

    public UpdateConfigurationTemplateRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.optionSettings == null) {
            this.setOptionSettings(new SdkInternalList<ConfigurationOptionSetting>(optionSettings.length));
        }
        for (ConfigurationOptionSetting ele : optionSettings) {
            this.optionSettings.add(ele);
        }
        return this;
    }

    public UpdateConfigurationTemplateRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        this.setOptionSettings(optionSettings);
        return this;
    }

    public List<OptionSpecification> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new SdkInternalList();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
            return;
        }
        this.optionsToRemove = new SdkInternalList<OptionSpecification>(optionsToRemove);
    }

    public UpdateConfigurationTemplateRequest withOptionsToRemove(OptionSpecification ... optionsToRemove) {
        if (this.optionsToRemove == null) {
            this.setOptionsToRemove(new SdkInternalList<OptionSpecification>(optionsToRemove.length));
        }
        for (OptionSpecification ele : optionsToRemove) {
            this.optionsToRemove.add(ele);
        }
        return this;
    }

    public UpdateConfigurationTemplateRequest withOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        this.setOptionsToRemove(optionsToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: ").append(this.getOptionSettings()).append(",");
        }
        if (this.getOptionsToRemove() != null) {
            sb.append("OptionsToRemove: ").append(this.getOptionsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationTemplateRequest)) {
            return false;
        }
        UpdateConfigurationTemplateRequest other = (UpdateConfigurationTemplateRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        if (other.getOptionSettings() != null && !other.getOptionSettings().equals(this.getOptionSettings())) {
            return false;
        }
        if (other.getOptionsToRemove() == null ^ this.getOptionsToRemove() == null) {
            return false;
        }
        return other.getOptionsToRemove() == null || other.getOptionsToRemove().equals(this.getOptionsToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : this.getOptionSettings().hashCode());
        hashCode = 31 * hashCode + (this.getOptionsToRemove() == null ? 0 : this.getOptionsToRemove().hashCode());
        return hashCode;
    }

    @Override
    public UpdateConfigurationTemplateRequest clone() {
        return (UpdateConfigurationTemplateRequest)super.clone();
    }
}

