/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupDetail;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowInstancesDetailMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class JobFlowInstancesDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String masterInstanceType;
    private String masterPublicDnsName;
    private String masterInstanceId;
    private String slaveInstanceType;
    private Integer instanceCount;
    private SdkInternalList<InstanceGroupDetail> instanceGroups;
    private Integer normalizedInstanceHours;
    private String ec2KeyName;
    private String ec2SubnetId;
    private PlacementType placement;
    private Boolean keepJobFlowAliveWhenNoSteps;
    private Boolean terminationProtected;
    private String hadoopVersion;

    public JobFlowInstancesDetail() {
    }

    public JobFlowInstancesDetail(String masterInstanceType, String slaveInstanceType, Integer instanceCount) {
        this.setMasterInstanceType(masterInstanceType);
        this.setSlaveInstanceType(slaveInstanceType);
        this.setInstanceCount(instanceCount);
    }

    public void setMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
    }

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public JobFlowInstancesDetail withMasterInstanceType(String masterInstanceType) {
        this.setMasterInstanceType(masterInstanceType);
        return this;
    }

    public void setMasterPublicDnsName(String masterPublicDnsName) {
        this.masterPublicDnsName = masterPublicDnsName;
    }

    public String getMasterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public JobFlowInstancesDetail withMasterPublicDnsName(String masterPublicDnsName) {
        this.setMasterPublicDnsName(masterPublicDnsName);
        return this;
    }

    public void setMasterInstanceId(String masterInstanceId) {
        this.masterInstanceId = masterInstanceId;
    }

    public String getMasterInstanceId() {
        return this.masterInstanceId;
    }

    public JobFlowInstancesDetail withMasterInstanceId(String masterInstanceId) {
        this.setMasterInstanceId(masterInstanceId);
        return this;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public JobFlowInstancesDetail withSlaveInstanceType(String slaveInstanceType) {
        this.setSlaveInstanceType(slaveInstanceType);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public JobFlowInstancesDetail withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public List<InstanceGroupDetail> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new SdkInternalList();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        this.instanceGroups = new SdkInternalList<InstanceGroupDetail>(instanceGroups);
    }

    public JobFlowInstancesDetail withInstanceGroups(InstanceGroupDetail ... instanceGroups) {
        if (this.instanceGroups == null) {
            this.setInstanceGroups(new SdkInternalList<InstanceGroupDetail>(instanceGroups.length));
        }
        for (InstanceGroupDetail ele : instanceGroups) {
            this.instanceGroups.add(ele);
        }
        return this;
    }

    public JobFlowInstancesDetail withInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
        return this;
    }

    public void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.normalizedInstanceHours = normalizedInstanceHours;
    }

    public Integer getNormalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public JobFlowInstancesDetail withNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.setNormalizedInstanceHours(normalizedInstanceHours);
        return this;
    }

    public void setEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
    }

    public String getEc2KeyName() {
        return this.ec2KeyName;
    }

    public JobFlowInstancesDetail withEc2KeyName(String ec2KeyName) {
        this.setEc2KeyName(ec2KeyName);
        return this;
    }

    public void setEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
    }

    public String getEc2SubnetId() {
        return this.ec2SubnetId;
    }

    public JobFlowInstancesDetail withEc2SubnetId(String ec2SubnetId) {
        this.setEc2SubnetId(ec2SubnetId);
        return this;
    }

    public void setPlacement(PlacementType placement) {
        this.placement = placement;
    }

    public PlacementType getPlacement() {
        return this.placement;
    }

    public JobFlowInstancesDetail withPlacement(PlacementType placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
    }

    public Boolean getKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public JobFlowInstancesDetail withKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.setKeepJobFlowAliveWhenNoSteps(keepJobFlowAliveWhenNoSteps);
        return this;
    }

    public Boolean isKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public JobFlowInstancesDetail withTerminationProtected(Boolean terminationProtected) {
        this.setTerminationProtected(terminationProtected);
        return this;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public JobFlowInstancesDetail withHadoopVersion(String hadoopVersion) {
        this.setHadoopVersion(hadoopVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMasterInstanceType() != null) {
            sb.append("MasterInstanceType: ").append(this.getMasterInstanceType()).append(",");
        }
        if (this.getMasterPublicDnsName() != null) {
            sb.append("MasterPublicDnsName: ").append(this.getMasterPublicDnsName()).append(",");
        }
        if (this.getMasterInstanceId() != null) {
            sb.append("MasterInstanceId: ").append(this.getMasterInstanceId()).append(",");
        }
        if (this.getSlaveInstanceType() != null) {
            sb.append("SlaveInstanceType: ").append(this.getSlaveInstanceType()).append(",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: ").append(this.getInstanceCount()).append(",");
        }
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.getInstanceGroups()).append(",");
        }
        if (this.getNormalizedInstanceHours() != null) {
            sb.append("NormalizedInstanceHours: ").append(this.getNormalizedInstanceHours()).append(",");
        }
        if (this.getEc2KeyName() != null) {
            sb.append("Ec2KeyName: ").append(this.getEc2KeyName()).append(",");
        }
        if (this.getEc2SubnetId() != null) {
            sb.append("Ec2SubnetId: ").append(this.getEc2SubnetId()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getKeepJobFlowAliveWhenNoSteps() != null) {
            sb.append("KeepJobFlowAliveWhenNoSteps: ").append(this.getKeepJobFlowAliveWhenNoSteps()).append(",");
        }
        if (this.getTerminationProtected() != null) {
            sb.append("TerminationProtected: ").append(this.getTerminationProtected()).append(",");
        }
        if (this.getHadoopVersion() != null) {
            sb.append("HadoopVersion: ").append(this.getHadoopVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesDetail)) {
            return false;
        }
        JobFlowInstancesDetail other = (JobFlowInstancesDetail)obj;
        if (other.getMasterInstanceType() == null ^ this.getMasterInstanceType() == null) {
            return false;
        }
        if (other.getMasterInstanceType() != null && !other.getMasterInstanceType().equals(this.getMasterInstanceType())) {
            return false;
        }
        if (other.getMasterPublicDnsName() == null ^ this.getMasterPublicDnsName() == null) {
            return false;
        }
        if (other.getMasterPublicDnsName() != null && !other.getMasterPublicDnsName().equals(this.getMasterPublicDnsName())) {
            return false;
        }
        if (other.getMasterInstanceId() == null ^ this.getMasterInstanceId() == null) {
            return false;
        }
        if (other.getMasterInstanceId() != null && !other.getMasterInstanceId().equals(this.getMasterInstanceId())) {
            return false;
        }
        if (other.getSlaveInstanceType() == null ^ this.getSlaveInstanceType() == null) {
            return false;
        }
        if (other.getSlaveInstanceType() != null && !other.getSlaveInstanceType().equals(this.getSlaveInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !other.getInstanceGroups().equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getNormalizedInstanceHours() == null ^ this.getNormalizedInstanceHours() == null) {
            return false;
        }
        if (other.getNormalizedInstanceHours() != null && !other.getNormalizedInstanceHours().equals(this.getNormalizedInstanceHours())) {
            return false;
        }
        if (other.getEc2KeyName() == null ^ this.getEc2KeyName() == null) {
            return false;
        }
        if (other.getEc2KeyName() != null && !other.getEc2KeyName().equals(this.getEc2KeyName())) {
            return false;
        }
        if (other.getEc2SubnetId() == null ^ this.getEc2SubnetId() == null) {
            return false;
        }
        if (other.getEc2SubnetId() != null && !other.getEc2SubnetId().equals(this.getEc2SubnetId())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getKeepJobFlowAliveWhenNoSteps() == null ^ this.getKeepJobFlowAliveWhenNoSteps() == null) {
            return false;
        }
        if (other.getKeepJobFlowAliveWhenNoSteps() != null && !other.getKeepJobFlowAliveWhenNoSteps().equals(this.getKeepJobFlowAliveWhenNoSteps())) {
            return false;
        }
        if (other.getTerminationProtected() == null ^ this.getTerminationProtected() == null) {
            return false;
        }
        if (other.getTerminationProtected() != null && !other.getTerminationProtected().equals(this.getTerminationProtected())) {
            return false;
        }
        if (other.getHadoopVersion() == null ^ this.getHadoopVersion() == null) {
            return false;
        }
        return other.getHadoopVersion() == null || other.getHadoopVersion().equals(this.getHadoopVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMasterInstanceType() == null ? 0 : this.getMasterInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getMasterPublicDnsName() == null ? 0 : this.getMasterPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getMasterInstanceId() == null ? 0 : this.getMasterInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getSlaveInstanceType() == null ? 0 : this.getSlaveInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.getNormalizedInstanceHours() == null ? 0 : this.getNormalizedInstanceHours().hashCode());
        hashCode = 31 * hashCode + (this.getEc2KeyName() == null ? 0 : this.getEc2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2SubnetId() == null ? 0 : this.getEc2SubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getKeepJobFlowAliveWhenNoSteps() == null ? 0 : this.getKeepJobFlowAliveWhenNoSteps().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationProtected() == null ? 0 : this.getTerminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.getHadoopVersion() == null ? 0 : this.getHadoopVersion().hashCode());
        return hashCode;
    }

    public JobFlowInstancesDetail clone() {
        try {
            return (JobFlowInstancesDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobFlowInstancesDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

