/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Preset;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPresetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Preset> presets;
    private String nextPageToken;

    public List<Preset> getPresets() {
        if (this.presets == null) {
            this.presets = new SdkInternalList();
        }
        return this.presets;
    }

    public void setPresets(Collection<Preset> presets) {
        if (presets == null) {
            this.presets = null;
            return;
        }
        this.presets = new SdkInternalList<Preset>(presets);
    }

    public ListPresetsResult withPresets(Preset ... presets) {
        if (this.presets == null) {
            this.setPresets(new SdkInternalList<Preset>(presets.length));
        }
        for (Preset ele : presets) {
            this.presets.add(ele);
        }
        return this;
    }

    public ListPresetsResult withPresets(Collection<Preset> presets) {
        this.setPresets(presets);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public ListPresetsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPresets() != null) {
            sb.append("Presets: ").append(this.getPresets()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResult)) {
            return false;
        }
        ListPresetsResult other = (ListPresetsResult)obj;
        if (other.getPresets() == null ^ this.getPresets() == null) {
            return false;
        }
        if (other.getPresets() != null && !other.getPresets().equals(this.getPresets())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPresets() == null ? 0 : this.getPresets().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public ListPresetsResult clone() {
        try {
            return (ListPresetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

