/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elastictranscoder.model.Artwork;

@SdkInternalApi
public class ArtworkMarshaller {
    private static final MarshallingInfo<String> INPUTKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputKey").build();
    private static final MarshallingInfo<String> MAXWIDTH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxWidth").build();
    private static final MarshallingInfo<String> MAXHEIGHT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxHeight").build();
    private static final MarshallingInfo<String> SIZINGPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizingPolicy").build();
    private static final MarshallingInfo<String> PADDINGPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaddingPolicy").build();
    private static final MarshallingInfo<String> ALBUMARTFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlbumArtFormat").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encryption").build();
    private static final ArtworkMarshaller instance = new ArtworkMarshaller();

    public static ArtworkMarshaller getInstance() {
        return instance;
    }

    public void marshall(Artwork artwork, ProtocolMarshaller protocolMarshaller) {
        if (artwork == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(artwork.getInputKey(), INPUTKEY_BINDING);
            protocolMarshaller.marshall(artwork.getMaxWidth(), MAXWIDTH_BINDING);
            protocolMarshaller.marshall(artwork.getMaxHeight(), MAXHEIGHT_BINDING);
            protocolMarshaller.marshall(artwork.getSizingPolicy(), SIZINGPOLICY_BINDING);
            protocolMarshaller.marshall(artwork.getPaddingPolicy(), PADDINGPOLICY_BINDING);
            protocolMarshaller.marshall(artwork.getAlbumArtFormat(), ALBUMARTFORMAT_BINDING);
            protocolMarshaller.marshall(artwork.getEncryption(), ENCRYPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

