/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.EncryptionType;
import com.amazonaws.services.glacier.model.transform.EncryptionMarshaller;
import java.io.Serializable;

public class Encryption
implements Serializable,
Cloneable,
StructuredPojo {
    private String encryptionType;
    private String kMSKeyId;
    private String kMSContext;

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public Encryption withEncryptionType(String encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public Encryption withEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
        return this;
    }

    public void setKMSKeyId(String kMSKeyId) {
        this.kMSKeyId = kMSKeyId;
    }

    public String getKMSKeyId() {
        return this.kMSKeyId;
    }

    public Encryption withKMSKeyId(String kMSKeyId) {
        this.setKMSKeyId(kMSKeyId);
        return this;
    }

    public void setKMSContext(String kMSContext) {
        this.kMSContext = kMSContext;
    }

    public String getKMSContext() {
        return this.kMSContext;
    }

    public Encryption withKMSContext(String kMSContext) {
        this.setKMSContext(kMSContext);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionType() != null) {
            sb.append("EncryptionType: ").append(this.getEncryptionType()).append(",");
        }
        if (this.getKMSKeyId() != null) {
            sb.append("KMSKeyId: ").append(this.getKMSKeyId()).append(",");
        }
        if (this.getKMSContext() != null) {
            sb.append("KMSContext: ").append(this.getKMSContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Encryption)) {
            return false;
        }
        Encryption other = (Encryption)obj;
        if (other.getEncryptionType() == null ^ this.getEncryptionType() == null) {
            return false;
        }
        if (other.getEncryptionType() != null && !other.getEncryptionType().equals(this.getEncryptionType())) {
            return false;
        }
        if (other.getKMSKeyId() == null ^ this.getKMSKeyId() == null) {
            return false;
        }
        if (other.getKMSKeyId() != null && !other.getKMSKeyId().equals(this.getKMSKeyId())) {
            return false;
        }
        if (other.getKMSContext() == null ^ this.getKMSContext() == null) {
            return false;
        }
        return other.getKMSContext() == null || other.getKMSContext().equals(this.getKMSContext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionType() == null ? 0 : this.getEncryptionType().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyId() == null ? 0 : this.getKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKMSContext() == null ? 0 : this.getKMSContext().hashCode());
        return hashCode;
    }

    public Encryption clone() {
        try {
            return (Encryption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

