/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class GetJobOutputRequestMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("jobId").build();
    private static final MarshallingInfo<String> RANGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Range").build();
    private static final GetJobOutputRequestMarshaller instance = new GetJobOutputRequestMarshaller();

    public static GetJobOutputRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(GetJobOutputRequest getJobOutputRequest, ProtocolMarshaller protocolMarshaller) {
        if (getJobOutputRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(getJobOutputRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(getJobOutputRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(getJobOutputRequest.getJobId(), JOBID_BINDING);
            protocolMarshaller.marshall(getJobOutputRequest.getRange(), RANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

