/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;
import java.io.InputStream;

@SdkInternalApi
public class UploadMultipartPartRequestMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").build();
    private static final MarshallingInfo<String> RANGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Range").build();
    private static final MarshallingInfo<InputStream> BODY_BINDING = MarshallingInfo.builder(MarshallingType.STREAM).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final UploadMultipartPartRequestMarshaller instance = new UploadMultipartPartRequestMarshaller();

    public static UploadMultipartPartRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(UploadMultipartPartRequest uploadMultipartPartRequest, ProtocolMarshaller protocolMarshaller) {
        if (uploadMultipartPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(uploadMultipartPartRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(uploadMultipartPartRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(uploadMultipartPartRequest.getUploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall(uploadMultipartPartRequest.getChecksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall(uploadMultipartPartRequest.getRange(), RANGE_BINDING);
            protocolMarshaller.marshall(uploadMultipartPartRequest.getBody(), BODY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

