/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Condition;
import com.amazonaws.services.glue.model.Logical;
import com.amazonaws.services.glue.model.transform.PredicateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Predicate
implements Serializable,
Cloneable,
StructuredPojo {
    private String logical;
    private List<Condition> conditions;

    public void setLogical(String logical) {
        this.logical = logical;
    }

    public String getLogical() {
        return this.logical;
    }

    public Predicate withLogical(String logical) {
        this.setLogical(logical);
        return this;
    }

    public Predicate withLogical(Logical logical) {
        this.logical = logical.toString();
        return this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<Condition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<Condition>(conditions);
    }

    public Predicate withConditions(Condition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<Condition>(conditions.length));
        }
        for (Condition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public Predicate withConditions(Collection<Condition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogical() != null) {
            sb.append("Logical: ").append(this.getLogical()).append(",");
        }
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        if (other.getLogical() == null ^ this.getLogical() == null) {
            return false;
        }
        if (other.getLogical() != null && !other.getLogical().equals(this.getLogical())) {
            return false;
        }
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        return other.getConditions() == null || other.getConditions().equals(this.getConditions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogical() == null ? 0 : this.getLogical().hashCode());
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        return hashCode;
    }

    public Predicate clone() {
        try {
            return (Predicate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredicateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

