/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.importexport.model.Artifact;
import com.amazonaws.services.importexport.model.JobType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateJobResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobId;
    private String jobType;
    private String signature;
    private String signatureFileContents;
    private String warningMessage;
    private SdkInternalList<Artifact> artifactList;

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public CreateJobResult withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getJobType() {
        return this.jobType;
    }

    public CreateJobResult withJobType(String jobType) {
        this.setJobType(jobType);
        return this;
    }

    public void setJobType(JobType jobType) {
        this.withJobType(jobType);
    }

    public CreateJobResult withJobType(JobType jobType) {
        this.jobType = jobType.toString();
        return this;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public CreateJobResult withSignature(String signature) {
        this.setSignature(signature);
        return this;
    }

    public void setSignatureFileContents(String signatureFileContents) {
        this.signatureFileContents = signatureFileContents;
    }

    public String getSignatureFileContents() {
        return this.signatureFileContents;
    }

    public CreateJobResult withSignatureFileContents(String signatureFileContents) {
        this.setSignatureFileContents(signatureFileContents);
        return this;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public CreateJobResult withWarningMessage(String warningMessage) {
        this.setWarningMessage(warningMessage);
        return this;
    }

    public List<Artifact> getArtifactList() {
        if (this.artifactList == null) {
            this.artifactList = new SdkInternalList();
        }
        return this.artifactList;
    }

    public void setArtifactList(Collection<Artifact> artifactList) {
        if (artifactList == null) {
            this.artifactList = null;
            return;
        }
        this.artifactList = new SdkInternalList<Artifact>(artifactList);
    }

    public CreateJobResult withArtifactList(Artifact ... artifactList) {
        if (this.artifactList == null) {
            this.setArtifactList(new SdkInternalList<Artifact>(artifactList.length));
        }
        for (Artifact ele : artifactList) {
            this.artifactList.add(ele);
        }
        return this;
    }

    public CreateJobResult withArtifactList(Collection<Artifact> artifactList) {
        this.setArtifactList(artifactList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getJobType() != null) {
            sb.append("JobType: ").append(this.getJobType()).append(",");
        }
        if (this.getSignature() != null) {
            sb.append("Signature: ").append(this.getSignature()).append(",");
        }
        if (this.getSignatureFileContents() != null) {
            sb.append("SignatureFileContents: ").append(this.getSignatureFileContents()).append(",");
        }
        if (this.getWarningMessage() != null) {
            sb.append("WarningMessage: ").append(this.getWarningMessage()).append(",");
        }
        if (this.getArtifactList() != null) {
            sb.append("ArtifactList: ").append(this.getArtifactList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobResult)) {
            return false;
        }
        CreateJobResult other = (CreateJobResult)obj;
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getJobType() == null ^ this.getJobType() == null) {
            return false;
        }
        if (other.getJobType() != null && !other.getJobType().equals(this.getJobType())) {
            return false;
        }
        if (other.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        if (other.getSignature() != null && !other.getSignature().equals(this.getSignature())) {
            return false;
        }
        if (other.getSignatureFileContents() == null ^ this.getSignatureFileContents() == null) {
            return false;
        }
        if (other.getSignatureFileContents() != null && !other.getSignatureFileContents().equals(this.getSignatureFileContents())) {
            return false;
        }
        if (other.getWarningMessage() == null ^ this.getWarningMessage() == null) {
            return false;
        }
        if (other.getWarningMessage() != null && !other.getWarningMessage().equals(this.getWarningMessage())) {
            return false;
        }
        if (other.getArtifactList() == null ^ this.getArtifactList() == null) {
            return false;
        }
        return other.getArtifactList() == null || other.getArtifactList().equals(this.getArtifactList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getJobType() == null ? 0 : this.getJobType().hashCode());
        hashCode = 31 * hashCode + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        hashCode = 31 * hashCode + (this.getSignatureFileContents() == null ? 0 : this.getSignatureFileContents().hashCode());
        hashCode = 31 * hashCode + (this.getWarningMessage() == null ? 0 : this.getWarningMessage().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactList() == null ? 0 : this.getArtifactList().hashCode());
        return hashCode;
    }

    public CreateJobResult clone() {
        try {
            return (CreateJobResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

