/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector.model.AssetAttributes;
import com.amazonaws.services.inspector.model.AssetType;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.InspectorServiceAttributes;
import com.amazonaws.services.inspector.model.Severity;
import com.amazonaws.services.inspector.model.transform.FindingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Finding
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Integer schemaVersion;
    private String service;
    private InspectorServiceAttributes serviceAttributes;
    private String assetType;
    private AssetAttributes assetAttributes;
    private String id;
    private String title;
    private String description;
    private String recommendation;
    private String severity;
    private Double numericSeverity;
    private Integer confidence;
    private Boolean indicatorOfCompromise;
    private List<Attribute> attributes;
    private List<Attribute> userAttributes;
    private Date createdAt;
    private Date updatedAt;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Finding withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSchemaVersion(Integer schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public Finding withSchemaVersion(Integer schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public Finding withService(String service) {
        this.setService(service);
        return this;
    }

    public void setServiceAttributes(InspectorServiceAttributes serviceAttributes) {
        this.serviceAttributes = serviceAttributes;
    }

    public InspectorServiceAttributes getServiceAttributes() {
        return this.serviceAttributes;
    }

    public Finding withServiceAttributes(InspectorServiceAttributes serviceAttributes) {
        this.setServiceAttributes(serviceAttributes);
        return this;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public Finding withAssetType(String assetType) {
        this.setAssetType(assetType);
        return this;
    }

    public void setAssetType(AssetType assetType) {
        this.withAssetType(assetType);
    }

    public Finding withAssetType(AssetType assetType) {
        this.assetType = assetType.toString();
        return this;
    }

    public void setAssetAttributes(AssetAttributes assetAttributes) {
        this.assetAttributes = assetAttributes;
    }

    public AssetAttributes getAssetAttributes() {
        return this.assetAttributes;
    }

    public Finding withAssetAttributes(AssetAttributes assetAttributes) {
        this.setAssetAttributes(assetAttributes);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Finding withId(String id) {
        this.setId(id);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Finding withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Finding withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public Finding withRecommendation(String recommendation) {
        this.setRecommendation(recommendation);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Finding withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public void setSeverity(Severity severity) {
        this.withSeverity(severity);
    }

    public Finding withSeverity(Severity severity) {
        this.severity = severity.toString();
        return this;
    }

    public void setNumericSeverity(Double numericSeverity) {
        this.numericSeverity = numericSeverity;
    }

    public Double getNumericSeverity() {
        return this.numericSeverity;
    }

    public Finding withNumericSeverity(Double numericSeverity) {
        this.setNumericSeverity(numericSeverity);
        return this;
    }

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public Finding withConfidence(Integer confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public void setIndicatorOfCompromise(Boolean indicatorOfCompromise) {
        this.indicatorOfCompromise = indicatorOfCompromise;
    }

    public Boolean getIndicatorOfCompromise() {
        return this.indicatorOfCompromise;
    }

    public Finding withIndicatorOfCompromise(Boolean indicatorOfCompromise) {
        this.setIndicatorOfCompromise(indicatorOfCompromise);
        return this;
    }

    public Boolean isIndicatorOfCompromise() {
        return this.indicatorOfCompromise;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    public Finding withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<Attribute>(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public Finding withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<Attribute> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<Attribute> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<Attribute>(userAttributes);
    }

    public Finding withUserAttributes(Attribute ... userAttributes) {
        if (this.userAttributes == null) {
            this.setUserAttributes(new ArrayList<Attribute>(userAttributes.length));
        }
        for (Attribute ele : userAttributes) {
            this.userAttributes.add(ele);
        }
        return this;
    }

    public Finding withUserAttributes(Collection<Attribute> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Finding withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Finding withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion()).append(",");
        }
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService()).append(",");
        }
        if (this.getServiceAttributes() != null) {
            sb.append("ServiceAttributes: ").append(this.getServiceAttributes()).append(",");
        }
        if (this.getAssetType() != null) {
            sb.append("AssetType: ").append(this.getAssetType()).append(",");
        }
        if (this.getAssetAttributes() != null) {
            sb.append("AssetAttributes: ").append(this.getAssetAttributes()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRecommendation() != null) {
            sb.append("Recommendation: ").append(this.getRecommendation()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getNumericSeverity() != null) {
            sb.append("NumericSeverity: ").append(this.getNumericSeverity()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getIndicatorOfCompromise() != null) {
            sb.append("IndicatorOfCompromise: ").append(this.getIndicatorOfCompromise()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: ").append(this.getUserAttributes()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        if (other.getSchemaVersion() != null && !other.getSchemaVersion().equals(this.getSchemaVersion())) {
            return false;
        }
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        if (other.getService() != null && !other.getService().equals(this.getService())) {
            return false;
        }
        if (other.getServiceAttributes() == null ^ this.getServiceAttributes() == null) {
            return false;
        }
        if (other.getServiceAttributes() != null && !other.getServiceAttributes().equals(this.getServiceAttributes())) {
            return false;
        }
        if (other.getAssetType() == null ^ this.getAssetType() == null) {
            return false;
        }
        if (other.getAssetType() != null && !other.getAssetType().equals(this.getAssetType())) {
            return false;
        }
        if (other.getAssetAttributes() == null ^ this.getAssetAttributes() == null) {
            return false;
        }
        if (other.getAssetAttributes() != null && !other.getAssetAttributes().equals(this.getAssetAttributes())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRecommendation() == null ^ this.getRecommendation() == null) {
            return false;
        }
        if (other.getRecommendation() != null && !other.getRecommendation().equals(this.getRecommendation())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getNumericSeverity() == null ^ this.getNumericSeverity() == null) {
            return false;
        }
        if (other.getNumericSeverity() != null && !other.getNumericSeverity().equals(this.getNumericSeverity())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getIndicatorOfCompromise() == null ^ this.getIndicatorOfCompromise() == null) {
            return false;
        }
        if (other.getIndicatorOfCompromise() != null && !other.getIndicatorOfCompromise().equals(this.getIndicatorOfCompromise())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        return other.getUpdatedAt() == null || other.getUpdatedAt().equals(this.getUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        hashCode = 31 * hashCode + (this.getServiceAttributes() == null ? 0 : this.getServiceAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAssetType() == null ? 0 : this.getAssetType().hashCode());
        hashCode = 31 * hashCode + (this.getAssetAttributes() == null ? 0 : this.getAssetAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendation() == null ? 0 : this.getRecommendation().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getNumericSeverity() == null ? 0 : this.getNumericSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getIndicatorOfCompromise() == null ? 0 : this.getIndicatorOfCompromise().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        return hashCode;
    }

    public Finding clone() {
        try {
            return (Finding)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

