/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.JobExecutionsRolloutConfig;
import com.amazonaws.services.iot.model.PresignedUrlConfig;
import com.amazonaws.services.iot.model.TargetSelection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobId;
    private List<String> targets;
    private String documentSource;
    private String document;
    private String description;
    private PresignedUrlConfig presignedUrlConfig;
    private String targetSelection;
    private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
    private Map<String, String> documentParameters;

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public CreateJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public CreateJobRequest withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public CreateJobRequest withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setDocumentSource(String documentSource) {
        this.documentSource = documentSource;
    }

    public String getDocumentSource() {
        return this.documentSource;
    }

    public CreateJobRequest withDocumentSource(String documentSource) {
        this.setDocumentSource(documentSource);
        return this;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public String getDocument() {
        return this.document;
    }

    public CreateJobRequest withDocument(String document) {
        this.setDocument(document);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateJobRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setPresignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
        this.presignedUrlConfig = presignedUrlConfig;
    }

    public PresignedUrlConfig getPresignedUrlConfig() {
        return this.presignedUrlConfig;
    }

    public CreateJobRequest withPresignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
        this.setPresignedUrlConfig(presignedUrlConfig);
        return this;
    }

    public void setTargetSelection(String targetSelection) {
        this.targetSelection = targetSelection;
    }

    public String getTargetSelection() {
        return this.targetSelection;
    }

    public CreateJobRequest withTargetSelection(String targetSelection) {
        this.setTargetSelection(targetSelection);
        return this;
    }

    public CreateJobRequest withTargetSelection(TargetSelection targetSelection) {
        this.targetSelection = targetSelection.toString();
        return this;
    }

    public void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
        this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
    }

    public JobExecutionsRolloutConfig getJobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    public CreateJobRequest withJobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
        this.setJobExecutionsRolloutConfig(jobExecutionsRolloutConfig);
        return this;
    }

    public Map<String, String> getDocumentParameters() {
        return this.documentParameters;
    }

    public void setDocumentParameters(Map<String, String> documentParameters) {
        this.documentParameters = documentParameters;
    }

    public CreateJobRequest withDocumentParameters(Map<String, String> documentParameters) {
        this.setDocumentParameters(documentParameters);
        return this;
    }

    public CreateJobRequest addDocumentParametersEntry(String key, String value) {
        if (null == this.documentParameters) {
            this.documentParameters = new HashMap<String, String>();
        }
        if (this.documentParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.documentParameters.put(key, value);
        return this;
    }

    public CreateJobRequest clearDocumentParametersEntries() {
        this.documentParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getDocumentSource() != null) {
            sb.append("DocumentSource: ").append(this.getDocumentSource()).append(",");
        }
        if (this.getDocument() != null) {
            sb.append("Document: ").append(this.getDocument()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPresignedUrlConfig() != null) {
            sb.append("PresignedUrlConfig: ").append(this.getPresignedUrlConfig()).append(",");
        }
        if (this.getTargetSelection() != null) {
            sb.append("TargetSelection: ").append(this.getTargetSelection()).append(",");
        }
        if (this.getJobExecutionsRolloutConfig() != null) {
            sb.append("JobExecutionsRolloutConfig: ").append(this.getJobExecutionsRolloutConfig()).append(",");
        }
        if (this.getDocumentParameters() != null) {
            sb.append("DocumentParameters: ").append(this.getDocumentParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)obj;
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getDocumentSource() == null ^ this.getDocumentSource() == null) {
            return false;
        }
        if (other.getDocumentSource() != null && !other.getDocumentSource().equals(this.getDocumentSource())) {
            return false;
        }
        if (other.getDocument() == null ^ this.getDocument() == null) {
            return false;
        }
        if (other.getDocument() != null && !other.getDocument().equals(this.getDocument())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPresignedUrlConfig() == null ^ this.getPresignedUrlConfig() == null) {
            return false;
        }
        if (other.getPresignedUrlConfig() != null && !other.getPresignedUrlConfig().equals(this.getPresignedUrlConfig())) {
            return false;
        }
        if (other.getTargetSelection() == null ^ this.getTargetSelection() == null) {
            return false;
        }
        if (other.getTargetSelection() != null && !other.getTargetSelection().equals(this.getTargetSelection())) {
            return false;
        }
        if (other.getJobExecutionsRolloutConfig() == null ^ this.getJobExecutionsRolloutConfig() == null) {
            return false;
        }
        if (other.getJobExecutionsRolloutConfig() != null && !other.getJobExecutionsRolloutConfig().equals(this.getJobExecutionsRolloutConfig())) {
            return false;
        }
        if (other.getDocumentParameters() == null ^ this.getDocumentParameters() == null) {
            return false;
        }
        return other.getDocumentParameters() == null || other.getDocumentParameters().equals(this.getDocumentParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentSource() == null ? 0 : this.getDocumentSource().hashCode());
        hashCode = 31 * hashCode + (this.getDocument() == null ? 0 : this.getDocument().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPresignedUrlConfig() == null ? 0 : this.getPresignedUrlConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTargetSelection() == null ? 0 : this.getTargetSelection().hashCode());
        hashCode = 31 * hashCode + (this.getJobExecutionsRolloutConfig() == null ? 0 : this.getJobExecutionsRolloutConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentParameters() == null ? 0 : this.getDocumentParameters().hashCode());
        return hashCode;
    }

    @Override
    public CreateJobRequest clone() {
        return (CreateJobRequest)super.clone();
    }
}

