/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisfirehose.model.ProcessingConfiguration;
import java.util.List;

@SdkInternalApi
public class ProcessingConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<List> PROCESSORS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Processors").build();
    private static final ProcessingConfigurationMarshaller instance = new ProcessingConfigurationMarshaller();

    public static ProcessingConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProcessingConfiguration processingConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (processingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(processingConfiguration.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(processingConfiguration.getProcessors(), PROCESSORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

