/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.logs.model.MetricTransformation;

@SdkInternalApi
public class MetricTransformationMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").build();
    private static final MarshallingInfo<String> METRICNAMESPACE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricNamespace").build();
    private static final MarshallingInfo<String> METRICVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").build();
    private static final MarshallingInfo<Double> DEFAULTVALUE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultValue").build();
    private static final MetricTransformationMarshaller instance = new MetricTransformationMarshaller();

    public static MetricTransformationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricTransformation metricTransformation, ProtocolMarshaller protocolMarshaller) {
        if (metricTransformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(metricTransformation.getMetricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall(metricTransformation.getMetricNamespace(), METRICNAMESPACE_BINDING);
            protocolMarshaller.marshall(metricTransformation.getMetricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall(metricTransformation.getDefaultValue(), DEFAULTVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

