/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AudioDescription;
import com.amazonaws.services.mediaconvert.model.CaptionDescriptionPreset;
import com.amazonaws.services.mediaconvert.model.ContainerSettings;
import com.amazonaws.services.mediaconvert.model.VideoDescription;
import com.amazonaws.services.mediaconvert.model.transform.PresetSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PresetSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AudioDescription> audioDescriptions;
    private List<CaptionDescriptionPreset> captionDescriptions;
    private ContainerSettings containerSettings;
    private VideoDescription videoDescription;

    public List<AudioDescription> getAudioDescriptions() {
        return this.audioDescriptions;
    }

    public void setAudioDescriptions(Collection<AudioDescription> audioDescriptions) {
        if (audioDescriptions == null) {
            this.audioDescriptions = null;
            return;
        }
        this.audioDescriptions = new ArrayList<AudioDescription>(audioDescriptions);
    }

    public PresetSettings withAudioDescriptions(AudioDescription ... audioDescriptions) {
        if (this.audioDescriptions == null) {
            this.setAudioDescriptions(new ArrayList<AudioDescription>(audioDescriptions.length));
        }
        for (AudioDescription ele : audioDescriptions) {
            this.audioDescriptions.add(ele);
        }
        return this;
    }

    public PresetSettings withAudioDescriptions(Collection<AudioDescription> audioDescriptions) {
        this.setAudioDescriptions(audioDescriptions);
        return this;
    }

    public List<CaptionDescriptionPreset> getCaptionDescriptions() {
        return this.captionDescriptions;
    }

    public void setCaptionDescriptions(Collection<CaptionDescriptionPreset> captionDescriptions) {
        if (captionDescriptions == null) {
            this.captionDescriptions = null;
            return;
        }
        this.captionDescriptions = new ArrayList<CaptionDescriptionPreset>(captionDescriptions);
    }

    public PresetSettings withCaptionDescriptions(CaptionDescriptionPreset ... captionDescriptions) {
        if (this.captionDescriptions == null) {
            this.setCaptionDescriptions(new ArrayList<CaptionDescriptionPreset>(captionDescriptions.length));
        }
        for (CaptionDescriptionPreset ele : captionDescriptions) {
            this.captionDescriptions.add(ele);
        }
        return this;
    }

    public PresetSettings withCaptionDescriptions(Collection<CaptionDescriptionPreset> captionDescriptions) {
        this.setCaptionDescriptions(captionDescriptions);
        return this;
    }

    public void setContainerSettings(ContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
    }

    public ContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public PresetSettings withContainerSettings(ContainerSettings containerSettings) {
        this.setContainerSettings(containerSettings);
        return this;
    }

    public void setVideoDescription(VideoDescription videoDescription) {
        this.videoDescription = videoDescription;
    }

    public VideoDescription getVideoDescription() {
        return this.videoDescription;
    }

    public PresetSettings withVideoDescription(VideoDescription videoDescription) {
        this.setVideoDescription(videoDescription);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudioDescriptions() != null) {
            sb.append("AudioDescriptions: ").append(this.getAudioDescriptions()).append(",");
        }
        if (this.getCaptionDescriptions() != null) {
            sb.append("CaptionDescriptions: ").append(this.getCaptionDescriptions()).append(",");
        }
        if (this.getContainerSettings() != null) {
            sb.append("ContainerSettings: ").append(this.getContainerSettings()).append(",");
        }
        if (this.getVideoDescription() != null) {
            sb.append("VideoDescription: ").append(this.getVideoDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresetSettings)) {
            return false;
        }
        PresetSettings other = (PresetSettings)obj;
        if (other.getAudioDescriptions() == null ^ this.getAudioDescriptions() == null) {
            return false;
        }
        if (other.getAudioDescriptions() != null && !other.getAudioDescriptions().equals(this.getAudioDescriptions())) {
            return false;
        }
        if (other.getCaptionDescriptions() == null ^ this.getCaptionDescriptions() == null) {
            return false;
        }
        if (other.getCaptionDescriptions() != null && !other.getCaptionDescriptions().equals(this.getCaptionDescriptions())) {
            return false;
        }
        if (other.getContainerSettings() == null ^ this.getContainerSettings() == null) {
            return false;
        }
        if (other.getContainerSettings() != null && !other.getContainerSettings().equals(this.getContainerSettings())) {
            return false;
        }
        if (other.getVideoDescription() == null ^ this.getVideoDescription() == null) {
            return false;
        }
        return other.getVideoDescription() == null || other.getVideoDescription().equals(this.getVideoDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudioDescriptions() == null ? 0 : this.getAudioDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionDescriptions() == null ? 0 : this.getCaptionDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.getContainerSettings() == null ? 0 : this.getContainerSettings().hashCode());
        hashCode = 31 * hashCode + (this.getVideoDescription() == null ? 0 : this.getVideoDescription().hashCode());
        return hashCode;
    }

    public PresetSettings clone() {
        try {
            return (PresetSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PresetSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

