/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.TimecodeSource;
import com.amazonaws.services.mediaconvert.model.transform.TimecodeConfigMarshaller;
import java.io.Serializable;

public class TimecodeConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String anchor;
    private String source;
    private String start;
    private String timestampOffset;

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public TimecodeConfig withAnchor(String anchor) {
        this.setAnchor(anchor);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public TimecodeConfig withSource(String source) {
        this.setSource(source);
        return this;
    }

    public TimecodeConfig withSource(TimecodeSource source) {
        this.source = source.toString();
        return this;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getStart() {
        return this.start;
    }

    public TimecodeConfig withStart(String start) {
        this.setStart(start);
        return this;
    }

    public void setTimestampOffset(String timestampOffset) {
        this.timestampOffset = timestampOffset;
    }

    public String getTimestampOffset() {
        return this.timestampOffset;
    }

    public TimecodeConfig withTimestampOffset(String timestampOffset) {
        this.setTimestampOffset(timestampOffset);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnchor() != null) {
            sb.append("Anchor: ").append(this.getAnchor()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getStart() != null) {
            sb.append("Start: ").append(this.getStart()).append(",");
        }
        if (this.getTimestampOffset() != null) {
            sb.append("TimestampOffset: ").append(this.getTimestampOffset());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig)obj;
        if (other.getAnchor() == null ^ this.getAnchor() == null) {
            return false;
        }
        if (other.getAnchor() != null && !other.getAnchor().equals(this.getAnchor())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getStart() == null ^ this.getStart() == null) {
            return false;
        }
        if (other.getStart() != null && !other.getStart().equals(this.getStart())) {
            return false;
        }
        if (other.getTimestampOffset() == null ^ this.getTimestampOffset() == null) {
            return false;
        }
        return other.getTimestampOffset() == null || other.getTimestampOffset().equals(this.getTimestampOffset());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnchor() == null ? 0 : this.getAnchor().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getStart() == null ? 0 : this.getStart().hashCode());
        hashCode = 31 * hashCode + (this.getTimestampOffset() == null ? 0 : this.getTimestampOffset().hashCode());
        return hashCode;
    }

    public TimecodeConfig clone() {
        try {
            return (TimecodeConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimecodeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

