/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.Hdr10Metadata;

@SdkInternalApi
public class Hdr10MetadataMarshaller {
    private static final MarshallingInfo<Integer> BLUEPRIMARYX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluePrimaryX").build();
    private static final MarshallingInfo<Integer> BLUEPRIMARYY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluePrimaryY").build();
    private static final MarshallingInfo<Integer> GREENPRIMARYX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("greenPrimaryX").build();
    private static final MarshallingInfo<Integer> GREENPRIMARYY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("greenPrimaryY").build();
    private static final MarshallingInfo<Integer> MAXCONTENTLIGHTLEVEL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxContentLightLevel").build();
    private static final MarshallingInfo<Integer> MAXFRAMEAVERAGELIGHTLEVEL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxFrameAverageLightLevel").build();
    private static final MarshallingInfo<Integer> MAXLUMINANCE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxLuminance").build();
    private static final MarshallingInfo<Integer> MINLUMINANCE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minLuminance").build();
    private static final MarshallingInfo<Integer> REDPRIMARYX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redPrimaryX").build();
    private static final MarshallingInfo<Integer> REDPRIMARYY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("redPrimaryY").build();
    private static final MarshallingInfo<Integer> WHITEPOINTX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitePointX").build();
    private static final MarshallingInfo<Integer> WHITEPOINTY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitePointY").build();
    private static final Hdr10MetadataMarshaller instance = new Hdr10MetadataMarshaller();

    public static Hdr10MetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(Hdr10Metadata hdr10Metadata, ProtocolMarshaller protocolMarshaller) {
        if (hdr10Metadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hdr10Metadata.getBluePrimaryX(), BLUEPRIMARYX_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getBluePrimaryY(), BLUEPRIMARYY_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getGreenPrimaryX(), GREENPRIMARYX_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getGreenPrimaryY(), GREENPRIMARYY_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getMaxContentLightLevel(), MAXCONTENTLIGHTLEVEL_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getMaxFrameAverageLightLevel(), MAXFRAMEAVERAGELIGHTLEVEL_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getMaxLuminance(), MAXLUMINANCE_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getMinLuminance(), MINLUMINANCE_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getRedPrimaryX(), REDPRIMARYX_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getRedPrimaryY(), REDPRIMARYY_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getWhitePointX(), WHITEPOINTX_BINDING);
            protocolMarshaller.marshall(hdr10Metadata.getWhitePointY(), WHITEPOINTY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

