/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhub;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.migrationhub.AWSMigrationHub;
import com.amazonaws.services.migrationhub.AWSMigrationHubClientBuilder;
import com.amazonaws.services.migrationhub.model.AWSMigrationHubException;
import com.amazonaws.services.migrationhub.model.AccessDeniedException;
import com.amazonaws.services.migrationhub.model.AssociateCreatedArtifactRequest;
import com.amazonaws.services.migrationhub.model.AssociateCreatedArtifactResult;
import com.amazonaws.services.migrationhub.model.AssociateDiscoveredResourceRequest;
import com.amazonaws.services.migrationhub.model.AssociateDiscoveredResourceResult;
import com.amazonaws.services.migrationhub.model.CreateProgressUpdateStreamRequest;
import com.amazonaws.services.migrationhub.model.CreateProgressUpdateStreamResult;
import com.amazonaws.services.migrationhub.model.DeleteProgressUpdateStreamRequest;
import com.amazonaws.services.migrationhub.model.DeleteProgressUpdateStreamResult;
import com.amazonaws.services.migrationhub.model.DescribeApplicationStateRequest;
import com.amazonaws.services.migrationhub.model.DescribeApplicationStateResult;
import com.amazonaws.services.migrationhub.model.DescribeMigrationTaskRequest;
import com.amazonaws.services.migrationhub.model.DescribeMigrationTaskResult;
import com.amazonaws.services.migrationhub.model.DisassociateCreatedArtifactRequest;
import com.amazonaws.services.migrationhub.model.DisassociateCreatedArtifactResult;
import com.amazonaws.services.migrationhub.model.DisassociateDiscoveredResourceRequest;
import com.amazonaws.services.migrationhub.model.DisassociateDiscoveredResourceResult;
import com.amazonaws.services.migrationhub.model.DryRunOperationException;
import com.amazonaws.services.migrationhub.model.ImportMigrationTaskRequest;
import com.amazonaws.services.migrationhub.model.ImportMigrationTaskResult;
import com.amazonaws.services.migrationhub.model.InternalServerErrorException;
import com.amazonaws.services.migrationhub.model.InvalidInputException;
import com.amazonaws.services.migrationhub.model.ListCreatedArtifactsRequest;
import com.amazonaws.services.migrationhub.model.ListCreatedArtifactsResult;
import com.amazonaws.services.migrationhub.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.migrationhub.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.migrationhub.model.ListMigrationTasksRequest;
import com.amazonaws.services.migrationhub.model.ListMigrationTasksResult;
import com.amazonaws.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import com.amazonaws.services.migrationhub.model.ListProgressUpdateStreamsResult;
import com.amazonaws.services.migrationhub.model.NotifyApplicationStateRequest;
import com.amazonaws.services.migrationhub.model.NotifyApplicationStateResult;
import com.amazonaws.services.migrationhub.model.NotifyMigrationTaskStateRequest;
import com.amazonaws.services.migrationhub.model.NotifyMigrationTaskStateResult;
import com.amazonaws.services.migrationhub.model.PolicyErrorException;
import com.amazonaws.services.migrationhub.model.PutResourceAttributesRequest;
import com.amazonaws.services.migrationhub.model.PutResourceAttributesResult;
import com.amazonaws.services.migrationhub.model.ResourceNotFoundException;
import com.amazonaws.services.migrationhub.model.ServiceUnavailableException;
import com.amazonaws.services.migrationhub.model.UnauthorizedOperationException;
import com.amazonaws.services.migrationhub.model.transform.AssociateCreatedArtifactRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateCreatedArtifactResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateDiscoveredResourceRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateDiscoveredResourceResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.CreateProgressUpdateStreamRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.CreateProgressUpdateStreamResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DeleteProgressUpdateStreamRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DeleteProgressUpdateStreamResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeApplicationStateRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeApplicationStateResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeMigrationTaskRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeMigrationTaskResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateCreatedArtifactRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateCreatedArtifactResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateDiscoveredResourceRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateDiscoveredResourceResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ImportMigrationTaskRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ImportMigrationTaskResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListCreatedArtifactsRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListCreatedArtifactsResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListDiscoveredResourcesRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListDiscoveredResourcesResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListMigrationTasksRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListMigrationTasksResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListProgressUpdateStreamsRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListProgressUpdateStreamsResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyApplicationStateRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyApplicationStateResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyMigrationTaskStateRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyMigrationTaskStateResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.PutResourceAttributesRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.PutResourceAttributesResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;

@ThreadSafe
public class AWSMigrationHubClient
extends AmazonWebServiceClient
implements AWSMigrationHub {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMigrationHub.class);
    private static final String DEFAULT_SIGNING_NAME = "mgh";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperation").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyErrorException").withModeledClass(PolicyErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DryRunOperation").withModeledClass(DryRunOperationException.class)).withBaseServiceExceptionClass(AWSMigrationHubException.class));

    public static AWSMigrationHubClientBuilder builder() {
        return AWSMigrationHubClientBuilder.standard();
    }

    AWSMigrationHubClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mgh.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/migrationhub/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/migrationhub/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateCreatedArtifactResult associateCreatedArtifact(AssociateCreatedArtifactRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateCreatedArtifact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateCreatedArtifactResult executeAssociateCreatedArtifact(AssociateCreatedArtifactRequest associateCreatedArtifactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateCreatedArtifactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateCreatedArtifactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateCreatedArtifactRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateCreatedArtifactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateCreatedArtifactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateCreatedArtifactResult associateCreatedArtifactResult = (AssociateCreatedArtifactResult)response.getAwsResponse();
            return associateCreatedArtifactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateDiscoveredResourceResult associateDiscoveredResource(AssociateDiscoveredResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateDiscoveredResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateDiscoveredResourceResult executeAssociateDiscoveredResource(AssociateDiscoveredResourceRequest associateDiscoveredResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateDiscoveredResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateDiscoveredResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateDiscoveredResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateDiscoveredResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateDiscoveredResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateDiscoveredResourceResult associateDiscoveredResourceResult = (AssociateDiscoveredResourceResult)response.getAwsResponse();
            return associateDiscoveredResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProgressUpdateStreamResult createProgressUpdateStream(CreateProgressUpdateStreamRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateProgressUpdateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProgressUpdateStreamResult executeCreateProgressUpdateStream(CreateProgressUpdateStreamRequest createProgressUpdateStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProgressUpdateStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProgressUpdateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProgressUpdateStreamRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createProgressUpdateStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateProgressUpdateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProgressUpdateStreamResult createProgressUpdateStreamResult = (CreateProgressUpdateStreamResult)response.getAwsResponse();
            return createProgressUpdateStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProgressUpdateStreamResult deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteProgressUpdateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProgressUpdateStreamResult executeDeleteProgressUpdateStream(DeleteProgressUpdateStreamRequest deleteProgressUpdateStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProgressUpdateStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProgressUpdateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProgressUpdateStreamRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteProgressUpdateStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteProgressUpdateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProgressUpdateStreamResult deleteProgressUpdateStreamResult = (DeleteProgressUpdateStreamResult)response.getAwsResponse();
            return deleteProgressUpdateStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeApplicationStateResult describeApplicationState(DescribeApplicationStateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeApplicationState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeApplicationStateResult executeDescribeApplicationState(DescribeApplicationStateRequest describeApplicationStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeApplicationStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeApplicationStateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeApplicationStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeApplicationStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeApplicationStateResult describeApplicationStateResult = (DescribeApplicationStateResult)response.getAwsResponse();
            return describeApplicationStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMigrationTaskResult describeMigrationTask(DescribeMigrationTaskRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeMigrationTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMigrationTaskResult executeDescribeMigrationTask(DescribeMigrationTaskRequest describeMigrationTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMigrationTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMigrationTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMigrationTaskRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeMigrationTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeMigrationTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMigrationTaskResult describeMigrationTaskResult = (DescribeMigrationTaskResult)response.getAwsResponse();
            return describeMigrationTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateCreatedArtifactResult disassociateCreatedArtifact(DisassociateCreatedArtifactRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateCreatedArtifact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateCreatedArtifactResult executeDisassociateCreatedArtifact(DisassociateCreatedArtifactRequest disassociateCreatedArtifactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateCreatedArtifactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateCreatedArtifactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateCreatedArtifactRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateCreatedArtifactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateCreatedArtifactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateCreatedArtifactResult disassociateCreatedArtifactResult = (DisassociateCreatedArtifactResult)response.getAwsResponse();
            return disassociateCreatedArtifactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateDiscoveredResourceResult disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateDiscoveredResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateDiscoveredResourceResult executeDisassociateDiscoveredResource(DisassociateDiscoveredResourceRequest disassociateDiscoveredResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateDiscoveredResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateDiscoveredResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateDiscoveredResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateDiscoveredResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateDiscoveredResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateDiscoveredResourceResult disassociateDiscoveredResourceResult = (DisassociateDiscoveredResourceResult)response.getAwsResponse();
            return disassociateDiscoveredResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportMigrationTaskResult importMigrationTask(ImportMigrationTaskRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeImportMigrationTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportMigrationTaskResult executeImportMigrationTask(ImportMigrationTaskRequest importMigrationTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importMigrationTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportMigrationTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportMigrationTaskRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(importMigrationTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ImportMigrationTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportMigrationTaskResult importMigrationTaskResult = (ImportMigrationTaskResult)response.getAwsResponse();
            return importMigrationTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCreatedArtifactsResult listCreatedArtifacts(ListCreatedArtifactsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListCreatedArtifacts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCreatedArtifactsResult executeListCreatedArtifacts(ListCreatedArtifactsRequest listCreatedArtifactsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCreatedArtifactsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCreatedArtifactsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCreatedArtifactsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listCreatedArtifactsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListCreatedArtifactsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCreatedArtifactsResult listCreatedArtifactsResult = (ListCreatedArtifactsResult)response.getAwsResponse();
            return listCreatedArtifactsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDiscoveredResourcesResult listDiscoveredResources(ListDiscoveredResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDiscoveredResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDiscoveredResourcesResult executeListDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDiscoveredResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDiscoveredResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDiscoveredResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listDiscoveredResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDiscoveredResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDiscoveredResourcesResult listDiscoveredResourcesResult = (ListDiscoveredResourcesResult)response.getAwsResponse();
            return listDiscoveredResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMigrationTasksResult listMigrationTasks(ListMigrationTasksRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListMigrationTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMigrationTasksResult executeListMigrationTasks(ListMigrationTasksRequest listMigrationTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMigrationTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMigrationTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMigrationTasksRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listMigrationTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListMigrationTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMigrationTasksResult listMigrationTasksResult = (ListMigrationTasksResult)response.getAwsResponse();
            return listMigrationTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProgressUpdateStreamsResult listProgressUpdateStreams(ListProgressUpdateStreamsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListProgressUpdateStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProgressUpdateStreamsResult executeListProgressUpdateStreams(ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProgressUpdateStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProgressUpdateStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProgressUpdateStreamsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listProgressUpdateStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListProgressUpdateStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProgressUpdateStreamsResult listProgressUpdateStreamsResult = (ListProgressUpdateStreamsResult)response.getAwsResponse();
            return listProgressUpdateStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public NotifyApplicationStateResult notifyApplicationState(NotifyApplicationStateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeNotifyApplicationState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final NotifyApplicationStateResult executeNotifyApplicationState(NotifyApplicationStateRequest notifyApplicationStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(notifyApplicationStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<NotifyApplicationStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new NotifyApplicationStateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(notifyApplicationStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new NotifyApplicationStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            NotifyApplicationStateResult notifyApplicationStateResult = (NotifyApplicationStateResult)response.getAwsResponse();
            return notifyApplicationStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public NotifyMigrationTaskStateResult notifyMigrationTaskState(NotifyMigrationTaskStateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeNotifyMigrationTaskState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final NotifyMigrationTaskStateResult executeNotifyMigrationTaskState(NotifyMigrationTaskStateRequest notifyMigrationTaskStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(notifyMigrationTaskStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<NotifyMigrationTaskStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new NotifyMigrationTaskStateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(notifyMigrationTaskStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new NotifyMigrationTaskStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            NotifyMigrationTaskStateResult notifyMigrationTaskStateResult = (NotifyMigrationTaskStateResult)response.getAwsResponse();
            return notifyMigrationTaskStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourceAttributesResult putResourceAttributes(PutResourceAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutResourceAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourceAttributesResult executePutResourceAttributes(PutResourceAttributesRequest putResourceAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourceAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourceAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourceAttributesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putResourceAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutResourceAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourceAttributesResult putResourceAttributesResult = (PutResourceAttributesResult)response.getAwsResponse();
            return putResourceAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

