/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.DefaultMessageMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String body;
    private Map<String, List<String>> substitutions;

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public DefaultMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public DefaultMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public DefaultMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public DefaultMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)obj;
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        return other.getSubstitutions() == null || other.getSubstitutions().equals(this.getSubstitutions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        return hashCode;
    }

    public DefaultMessage clone() {
        try {
            return (DefaultMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefaultMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

