/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.auth;

import com.amazonaws.util.ValidationUtils;

public class GetIamAuthTokenRequest {
    private final String hostname;
    private final int port;
    private final String userName;

    public GetIamAuthTokenRequest(String hostname, int port, String userName) {
        this.hostname = ValidationUtils.assertStringNotEmpty(hostname, "hostname");
        this.port = ValidationUtils.assertIsPositive(port, "port");
        this.userName = ValidationUtils.assertStringNotEmpty(userName, "userName");
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String hostname;
        private int port;
        private String userName;

        private Builder() {
        }

        public Builder hostname(String endpoint) {
            this.hostname = endpoint;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public GetIamAuthTokenRequest build() {
            return new GetIamAuthTokenRequest(this.hostname, this.port, this.userName);
        }
    }
}

