/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class HsmConfiguration
implements Serializable,
Cloneable {
    private String hsmConfigurationIdentifier;
    private String description;
    private String hsmIpAddress;
    private String hsmPartitionName;
    private SdkInternalList<Tag> tags;

    public void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
    }

    public String getHsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public HsmConfiguration withHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
        this.setHsmConfigurationIdentifier(hsmConfigurationIdentifier);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public HsmConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setHsmIpAddress(String hsmIpAddress) {
        this.hsmIpAddress = hsmIpAddress;
    }

    public String getHsmIpAddress() {
        return this.hsmIpAddress;
    }

    public HsmConfiguration withHsmIpAddress(String hsmIpAddress) {
        this.setHsmIpAddress(hsmIpAddress);
        return this;
    }

    public void setHsmPartitionName(String hsmPartitionName) {
        this.hsmPartitionName = hsmPartitionName;
    }

    public String getHsmPartitionName() {
        return this.hsmPartitionName;
    }

    public HsmConfiguration withHsmPartitionName(String hsmPartitionName) {
        this.setHsmPartitionName(hsmPartitionName);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public HsmConfiguration withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public HsmConfiguration withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: ").append(this.getHsmConfigurationIdentifier()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getHsmIpAddress() != null) {
            sb.append("HsmIpAddress: ").append(this.getHsmIpAddress()).append(",");
        }
        if (this.getHsmPartitionName() != null) {
            sb.append("HsmPartitionName: ").append(this.getHsmPartitionName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmConfiguration)) {
            return false;
        }
        HsmConfiguration other = (HsmConfiguration)obj;
        if (other.getHsmConfigurationIdentifier() == null ^ this.getHsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.getHsmConfigurationIdentifier() != null && !other.getHsmConfigurationIdentifier().equals(this.getHsmConfigurationIdentifier())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getHsmIpAddress() == null ^ this.getHsmIpAddress() == null) {
            return false;
        }
        if (other.getHsmIpAddress() != null && !other.getHsmIpAddress().equals(this.getHsmIpAddress())) {
            return false;
        }
        if (other.getHsmPartitionName() == null ^ this.getHsmPartitionName() == null) {
            return false;
        }
        if (other.getHsmPartitionName() != null && !other.getHsmPartitionName().equals(this.getHsmPartitionName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHsmConfigurationIdentifier() == null ? 0 : this.getHsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getHsmIpAddress() == null ? 0 : this.getHsmIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getHsmPartitionName() == null ? 0 : this.getHsmPartitionName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public HsmConfiguration clone() {
        try {
            return (HsmConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

