/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceResult;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobRequest;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobResult;
import com.amazonaws.services.sagemaker.waiters.DescribeEndpointFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeNotebookInstanceFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeTrainingJobFunction;
import com.amazonaws.services.sagemaker.waiters.EndpointDeleted;
import com.amazonaws.services.sagemaker.waiters.EndpointInService;
import com.amazonaws.services.sagemaker.waiters.NotebookInstanceDeleted;
import com.amazonaws.services.sagemaker.waiters.NotebookInstanceInService;
import com.amazonaws.services.sagemaker.waiters.NotebookInstanceStopped;
import com.amazonaws.services.sagemaker.waiters.TrainingJobCompletedOrStopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonSageMakerWaiters {
    private final AmazonSageMaker client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonSageMakerWaiters(AmazonSageMaker client) {
        this.client = client;
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceStopped() {
        return new WaiterBuilder<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult>().withSdkFunction(new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new NotebookInstanceStopped.IsStoppedMatcher(), new NotebookInstanceStopped.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceDeleted() {
        return new WaiterBuilder<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult>().withSdkFunction(new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new NotebookInstanceDeleted.IsValidationExceptionMatcher(), new NotebookInstanceDeleted.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpointInService() {
        return new WaiterBuilder<DescribeEndpointRequest, DescribeEndpointResult>().withSdkFunction(new DescribeEndpointFunction(this.client)).withAcceptors(new EndpointInService.IsInServiceMatcher(), new EndpointInService.IsFailedMatcher(), new EndpointInService.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(120), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpointDeleted() {
        return new WaiterBuilder<DescribeEndpointRequest, DescribeEndpointResult>().withSdkFunction(new DescribeEndpointFunction(this.client)).withAcceptors(new EndpointDeleted.IsValidationExceptionMatcher(), new EndpointDeleted.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceInService() {
        return new WaiterBuilder<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult>().withSdkFunction(new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new NotebookInstanceInService.IsInServiceMatcher(), new NotebookInstanceInService.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTrainingJobRequest> trainingJobCompletedOrStopped() {
        return new WaiterBuilder<DescribeTrainingJobRequest, DescribeTrainingJobResult>().withSdkFunction(new DescribeTrainingJobFunction(this.client)).withAcceptors(new TrainingJobCompletedOrStopped.IsCompletedMatcher(), new TrainingJobCompletedOrStopped.IsStoppedMatcher(), new TrainingJobCompletedOrStopped.IsFailedMatcher(), new TrainingJobCompletedOrStopped.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(180), new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

