/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.AddHeaderAction;
import com.amazonaws.services.simpleemail.model.BounceAction;
import com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest;
import com.amazonaws.services.simpleemail.model.LambdaAction;
import com.amazonaws.services.simpleemail.model.ReceiptAction;
import com.amazonaws.services.simpleemail.model.ReceiptRule;
import com.amazonaws.services.simpleemail.model.S3Action;
import com.amazonaws.services.simpleemail.model.SNSAction;
import com.amazonaws.services.simpleemail.model.StopAction;
import com.amazonaws.services.simpleemail.model.WorkmailAction;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateReceiptRuleRequestMarshaller
implements Marshaller<Request<CreateReceiptRuleRequest>, CreateReceiptRuleRequest> {
    @Override
    public Request<CreateReceiptRuleRequest> marshall(CreateReceiptRuleRequest createReceiptRuleRequest) {
        ReceiptRule rule;
        if (createReceiptRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateReceiptRuleRequest> request = new DefaultRequest<CreateReceiptRuleRequest>(createReceiptRuleRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReceiptRuleRequest.getRuleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString(createReceiptRuleRequest.getRuleSetName()));
        }
        if (createReceiptRuleRequest.getAfter() != null) {
            request.addParameter("After", StringUtils.fromString(createReceiptRuleRequest.getAfter()));
        }
        if ((rule = createReceiptRuleRequest.getRule()) != null) {
            SdkInternalList actionsList;
            SdkInternalList recipientsList;
            if (rule.getName() != null) {
                request.addParameter("Rule.Name", StringUtils.fromString(rule.getName()));
            }
            if (rule.getEnabled() != null) {
                request.addParameter("Rule.Enabled", StringUtils.fromBoolean(rule.getEnabled()));
            }
            if (rule.getTlsPolicy() != null) {
                request.addParameter("Rule.TlsPolicy", StringUtils.fromString(rule.getTlsPolicy()));
            }
            if (!(recipientsList = (SdkInternalList)rule.getRecipients()).isEmpty() || !recipientsList.isAutoConstruct()) {
                int recipientsListIndex = 1;
                for (String recipientsListValue : recipientsList) {
                    if (recipientsListValue != null) {
                        request.addParameter("Rule.Recipients.member." + recipientsListIndex, StringUtils.fromString(recipientsListValue));
                    }
                    ++recipientsListIndex;
                }
            }
            if (!(actionsList = (SdkInternalList)rule.getActions()).isEmpty() || !actionsList.isAutoConstruct()) {
                int actionsListIndex = 1;
                for (ReceiptAction actionsListValue : actionsList) {
                    SNSAction sNSAction;
                    AddHeaderAction addHeaderAction;
                    StopAction stopAction;
                    LambdaAction lambdaAction;
                    WorkmailAction workmailAction;
                    BounceAction bounceAction;
                    S3Action s3Action = actionsListValue.getS3Action();
                    if (s3Action != null) {
                        if (s3Action.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn", StringUtils.fromString(s3Action.getTopicArn()));
                        }
                        if (s3Action.getBucketName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName", StringUtils.fromString(s3Action.getBucketName()));
                        }
                        if (s3Action.getObjectKeyPrefix() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix", StringUtils.fromString(s3Action.getObjectKeyPrefix()));
                        }
                        if (s3Action.getKmsKeyArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn", StringUtils.fromString(s3Action.getKmsKeyArn()));
                        }
                    }
                    if ((bounceAction = actionsListValue.getBounceAction()) != null) {
                        if (bounceAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn", StringUtils.fromString(bounceAction.getTopicArn()));
                        }
                        if (bounceAction.getSmtpReplyCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode", StringUtils.fromString(bounceAction.getSmtpReplyCode()));
                        }
                        if (bounceAction.getStatusCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode", StringUtils.fromString(bounceAction.getStatusCode()));
                        }
                        if (bounceAction.getMessage() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message", StringUtils.fromString(bounceAction.getMessage()));
                        }
                        if (bounceAction.getSender() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender", StringUtils.fromString(bounceAction.getSender()));
                        }
                    }
                    if ((workmailAction = actionsListValue.getWorkmailAction()) != null) {
                        if (workmailAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn", StringUtils.fromString(workmailAction.getTopicArn()));
                        }
                        if (workmailAction.getOrganizationArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.OrganizationArn", StringUtils.fromString(workmailAction.getOrganizationArn()));
                        }
                    }
                    if ((lambdaAction = actionsListValue.getLambdaAction()) != null) {
                        if (lambdaAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn", StringUtils.fromString(lambdaAction.getTopicArn()));
                        }
                        if (lambdaAction.getFunctionArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn", StringUtils.fromString(lambdaAction.getFunctionArn()));
                        }
                        if (lambdaAction.getInvocationType() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType", StringUtils.fromString(lambdaAction.getInvocationType()));
                        }
                    }
                    if ((stopAction = actionsListValue.getStopAction()) != null) {
                        if (stopAction.getScope() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope", StringUtils.fromString(stopAction.getScope()));
                        }
                        if (stopAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn", StringUtils.fromString(stopAction.getTopicArn()));
                        }
                    }
                    if ((addHeaderAction = actionsListValue.getAddHeaderAction()) != null) {
                        if (addHeaderAction.getHeaderName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName", StringUtils.fromString(addHeaderAction.getHeaderName()));
                        }
                        if (addHeaderAction.getHeaderValue() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue", StringUtils.fromString(addHeaderAction.getHeaderValue()));
                        }
                    }
                    if ((sNSAction = actionsListValue.getSNSAction()) != null) {
                        if (sNSAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn", StringUtils.fromString(sNSAction.getTopicArn()));
                        }
                        if (sNSAction.getEncoding() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.Encoding", StringUtils.fromString(sNSAction.getEncoding()));
                        }
                    }
                    ++actionsListIndex;
                }
            }
            if (rule.getScanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringUtils.fromBoolean(rule.getScanEnabled()));
            }
        }
        return request;
    }
}

