/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.core.Cancelable;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import java.util.concurrent.CancellationException;

public class AsyncCancelAndRetryExecutor
implements AsyncExecutor {
    private Cancelable currentCommandTryCatchFinally;
    private Settable<Void> commandDone;
    private boolean cancelledDueToRetryRequest;
    protected AsyncRunnable command;

    @Override
    public void execute(final AsyncRunnable cmd) {
        if (this.currentCommandTryCatchFinally != null) {
            throw new IllegalStateException("Already executing a command");
        }
        this.command = cmd;
        this.currentCommandTryCatchFinally = new TryCatchFinally(){

            @Override
            protected void doTry() throws Throwable {
                cmd.run();
            }

            @Override
            protected void doCatch(Throwable e) throws Throwable {
                if (!(e instanceof CancellationException) || AsyncCancelAndRetryExecutor.this.commandDone == null) {
                    throw e;
                }
                AsyncCancelAndRetryExecutor.this.cancelledDueToRetryRequest = true;
            }

            @Override
            protected void doFinally() throws Throwable {
                if (!AsyncCancelAndRetryExecutor.this.cancelledDueToRetryRequest) {
                    AsyncCancelAndRetryExecutor.this.command = null;
                }
                if (AsyncCancelAndRetryExecutor.this.commandDone != null) {
                    AsyncCancelAndRetryExecutor.this.commandDone.set(null);
                }
                AsyncCancelAndRetryExecutor.this.commandDone = null;
                AsyncCancelAndRetryExecutor.this.currentCommandTryCatchFinally = null;
            }
        };
    }

    public void cancelCurrentAndReexecute() {
        if (this.currentCommandTryCatchFinally != null && this.commandDone == null) {
            this.commandDone = new Settable();
            this.currentCommandTryCatchFinally.cancel(null);
            new Task(new Promise[]{this.commandDone}){

                @Override
                protected void doExecute() throws Throwable {
                    if (AsyncCancelAndRetryExecutor.this.cancelledDueToRetryRequest) {
                        AsyncCancelAndRetryExecutor.this.execute(AsyncCancelAndRetryExecutor.this.command);
                    }
                }
            };
        }
    }
}

