/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.ScheduleLambdaFunctionDecisionAttributes;

class LambdaFunctionDecisionStateMachine
extends DecisionStateMachineBase {
    private ScheduleLambdaFunctionDecisionAttributes scheduleAttributes;

    LambdaFunctionDecisionStateMachine(DecisionId id, ScheduleLambdaFunctionDecisionAttributes scheduleAttributes) {
        super(id);
        this.scheduleAttributes = scheduleAttributes;
    }

    LambdaFunctionDecisionStateMachine(DecisionId id, ScheduleLambdaFunctionDecisionAttributes scheduleAttributes, DecisionState state) {
        super(id, state);
        this.scheduleAttributes = scheduleAttributes;
    }

    @Override
    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createScheduleLambdaFunctionDecision();
            }
        }
        return null;
    }

    @Override
    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_INITIATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    @Override
    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.INITIATED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    private Decision createScheduleLambdaFunctionDecision() {
        Decision decision = new Decision();
        decision.setScheduleLambdaFunctionDecisionAttributes(this.scheduleAttributes);
        decision.setDecisionType(DecisionType.ScheduleLambdaFunction.toString());
        return decision;
    }
}

