/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.CircularLongBuffer;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;

public class Throttler {
    private static final Log log = LogFactory.getLog(Throttler.class);
    private final String name_;
    private CircularLongBuffer checkPointTimes_;
    private long index_;
    private long rateInterval_;
    private long rateIntervalMilliseconds_;
    private long overslept_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throttler(String name, double maxRatePerSecond, long rateIntervalMilliseconds) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name_ = name;
        if (maxRatePerSecond <= 0.0) {
            throw new IllegalArgumentException("0 or negative maxRatePerSecond");
        }
        if (rateIntervalMilliseconds <= 0L) {
            throw new IllegalArgumentException("0 or negative rateIntervalMilliseconds");
        }
        Throttler throttler = this;
        synchronized (throttler) {
            this.rateIntervalMilliseconds_ = rateIntervalMilliseconds;
            this.setMaxRatePerSecond(maxRatePerSecond);
        }
    }

    public synchronized void setMaxRatePerSecond(double maxRatePerSecond) {
        int maxMessagesPerRateInterval = (int)(maxRatePerSecond * (double)this.rateIntervalMilliseconds_ / 1000.0);
        if (maxMessagesPerRateInterval == 0) {
            maxMessagesPerRateInterval = 1;
            this.rateInterval_ = (long)(1.0 / maxRatePerSecond * 1000.0);
        } else {
            this.rateInterval_ = this.rateIntervalMilliseconds_;
        }
        if (this.checkPointTimes_ != null) {
            int oldSize = this.checkPointTimes_.size();
            this.checkPointTimes_ = this.checkPointTimes_.copy(this.index_ - (long)maxMessagesPerRateInterval, maxMessagesPerRateInterval);
            this.index_ = Math.min(this.checkPointTimes_.size(), oldSize);
        } else {
            this.checkPointTimes_ = new CircularLongBuffer(maxMessagesPerRateInterval);
            this.index_ = 0L;
        }
        log.debug("new rate=" + maxRatePerSecond + " (msg/sec)");
    }

    public synchronized void throttle(int count) throws InterruptedException {
        int i = 0;
        while (i < count) {
            this.throttle();
            ++i;
        }
    }

    public synchronized void throttle() throws InterruptedException {
        long elapsed;
        long now = System.currentTimeMillis();
        long checkPoint = this.checkPointTimes_.get(this.index_);
        if (checkPoint > 0L && (elapsed = now - checkPoint) >= 0L && elapsed < this.rateInterval_) {
            long sleepInterval = this.rateInterval_ - elapsed - this.overslept_;
            this.overslept_ = 0L;
            if (sleepInterval > 0L) {
                if (log.isTraceEnabled()) {
                    log.debug("Throttling " + this.name_ + ": called " + this.checkPointTimes_.size() + " times in last " + elapsed + " milliseconds. Going to sleep for " + sleepInterval + " milliseconds.");
                }
                long t = System.currentTimeMillis();
                Thread.sleep(sleepInterval);
                this.overslept_ = System.currentTimeMillis() - t - sleepInterval;
            }
        }
        this.checkPointTimes_.set(this.index_++, System.currentTimeMillis());
    }
}

