/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.storagegateway.model.ErrorCode;
import com.amazonaws.services.storagegateway.model.transform.StorageGatewayErrorMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StorageGatewayError
implements Serializable,
Cloneable,
StructuredPojo {
    private String errorCode;
    private Map<String, String> errorDetails;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public StorageGatewayError withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.withErrorCode(errorCode);
    }

    public StorageGatewayError withErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode.toString();
        return this;
    }

    public Map<String, String> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(Map<String, String> errorDetails) {
        this.errorDetails = errorDetails;
    }

    public StorageGatewayError withErrorDetails(Map<String, String> errorDetails) {
        this.setErrorDetails(errorDetails);
        return this;
    }

    public StorageGatewayError addErrorDetailsEntry(String key, String value) {
        if (null == this.errorDetails) {
            this.errorDetails = new HashMap<String, String>();
        }
        if (this.errorDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.errorDetails.put(key, value);
        return this;
    }

    public StorageGatewayError clearErrorDetailsEntries() {
        this.errorDetails = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getErrorDetails() != null) {
            sb.append("ErrorDetails: ").append(this.getErrorDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageGatewayError)) {
            return false;
        }
        StorageGatewayError other = (StorageGatewayError)obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getErrorDetails() == null ^ this.getErrorDetails() == null) {
            return false;
        }
        return other.getErrorDetails() == null || other.getErrorDetails().equals(this.getErrorDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getErrorDetails() == null ? 0 : this.getErrorDetails().hashCode());
        return hashCode;
    }

    public StorageGatewayError clone() {
        try {
            return (StorageGatewayError)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageGatewayErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

