/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.workdocs.AmazonWorkDocs;
import com.amazonaws.services.workdocs.ContentManagerBuilder;
import com.amazonaws.services.workdocs.GetDocumentStreamRequest;
import com.amazonaws.services.workdocs.GetDocumentStreamResult;
import com.amazonaws.services.workdocs.UploadDocumentStreamRequest;
import com.amazonaws.services.workdocs.UploadDocumentStreamResult;
import com.amazonaws.services.workdocs.model.DocumentSourceType;
import com.amazonaws.services.workdocs.model.DocumentVersionStatus;
import com.amazonaws.services.workdocs.model.GetDocumentRequest;
import com.amazonaws.services.workdocs.model.GetDocumentResult;
import com.amazonaws.services.workdocs.model.GetDocumentVersionRequest;
import com.amazonaws.services.workdocs.model.GetDocumentVersionResult;
import com.amazonaws.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import com.amazonaws.services.workdocs.model.InitiateDocumentVersionUploadResult;
import com.amazonaws.services.workdocs.model.UpdateDocumentVersionRequest;
import com.amazonaws.services.workdocs.model.UpdateDocumentVersionResult;
import com.amazonaws.services.workdocs.model.UploadMetadata;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

@ThreadSafe
@SdkInternalApi
public class ContentManager {
    private final String authenticationToken;
    private final AmazonWorkDocs client;

    @SdkInternalApi
    ContentManager(ContentManagerBuilder contentManagerBuilder) {
        if (contentManagerBuilder == null) {
            throw new IllegalArgumentException();
        }
        AmazonWorkDocs client = contentManagerBuilder.getWorkDocsClient();
        if (client == null) {
            throw new IllegalArgumentException("AmazonWorkDocs client must be specified.");
        }
        this.client = client;
        this.authenticationToken = contentManagerBuilder.getAuthenticationToken();
    }

    @SdkInternalApi
    protected AmazonWorkDocs getWorkDocsClient() {
        return this.client;
    }

    public GetDocumentStreamResult getDocumentStream(GetDocumentStreamRequest getDocumentStreamRequest) {
        String versionId = getDocumentStreamRequest.getVersionId();
        if (versionId == null) {
            GetDocumentRequest getDocumentRequest = new GetDocumentRequest();
            getDocumentRequest.setDocumentId(getDocumentStreamRequest.getDocumentId());
            String requestAuthenticationToken = getDocumentStreamRequest.getAuthenticationToken();
            if (requestAuthenticationToken != null) {
                getDocumentRequest.setAuthenticationToken(requestAuthenticationToken);
            } else {
                getDocumentRequest.setAuthenticationToken(this.authenticationToken);
            }
            GetDocumentResult result = this.client.getDocument(getDocumentRequest);
            versionId = result.getMetadata().getLatestVersionMetadata().getId();
        }
        GetDocumentStreamResult getDocumentStreamResult = new GetDocumentStreamResult(getDocumentStreamRequest);
        getDocumentStreamResult.setVersionId(versionId);
        InputStream stream = this.getDocumentVersionStream(getDocumentStreamRequest.getDocumentId(), versionId);
        getDocumentStreamResult.setStream(stream);
        return getDocumentStreamResult;
    }

    private InputStream getDocumentVersionStream(String documentId, String versionId) {
        GetDocumentVersionRequest getDocumentVersionRequest = new GetDocumentVersionRequest();
        getDocumentVersionRequest.setDocumentId(documentId);
        getDocumentVersionRequest.setVersionId(versionId);
        getDocumentVersionRequest.setFields("SOURCE");
        getDocumentVersionRequest.setAuthenticationToken(this.authenticationToken);
        GetDocumentVersionResult result = this.client.getDocumentVersion(getDocumentVersionRequest);
        String downloadUrl = result.getMetadata().getSource().get(DocumentSourceType.ORIGINAL.name());
        try {
            URL documentUrl = new URL(downloadUrl);
            return documentUrl.openStream();
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
    }

    public UploadDocumentStreamResult uploadDocumentStream(UploadDocumentStreamRequest uploadDocumentStreamRequest) {
        InputStream stream = uploadDocumentStreamRequest.getStream();
        if (stream == null) {
            throw new IllegalArgumentException("InputStream must be specified.");
        }
        InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest = new InitiateDocumentVersionUploadRequest();
        initiateDocumentVersionUploadRequest.setParentFolderId(uploadDocumentStreamRequest.getParentFolderId());
        initiateDocumentVersionUploadRequest.setName(uploadDocumentStreamRequest.getDocumentName());
        initiateDocumentVersionUploadRequest.setContentType(uploadDocumentStreamRequest.getContentType());
        initiateDocumentVersionUploadRequest.setContentCreatedTimestamp(uploadDocumentStreamRequest.getContentCreatedTimestamp());
        initiateDocumentVersionUploadRequest.setContentModifiedTimestamp(uploadDocumentStreamRequest.getContentModifiedTimestamp());
        initiateDocumentVersionUploadRequest.setDocumentSizeInBytes(uploadDocumentStreamRequest.getDocumentSizeInBytes());
        initiateDocumentVersionUploadRequest.setId(uploadDocumentStreamRequest.getDocumentId());
        String requestAuthenticationToken = uploadDocumentStreamRequest.getAuthenticationToken();
        if (requestAuthenticationToken != null) {
            initiateDocumentVersionUploadRequest.setAuthenticationToken(requestAuthenticationToken);
        } else {
            initiateDocumentVersionUploadRequest.setAuthenticationToken(this.authenticationToken);
        }
        InitiateDocumentVersionUploadResult result = this.client.initiateDocumentVersionUpload(initiateDocumentVersionUploadRequest);
        UploadMetadata uploadMetadata = result.getUploadMetadata();
        String documentId = result.getMetadata().getId();
        String versionId = result.getMetadata().getLatestVersionMetadata().getId();
        String uploadUrl = uploadMetadata.getUploadUrl();
        try {
            URL url = new URL(uploadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", uploadDocumentStreamRequest.getContentType());
            connection.setRequestProperty("x-amz-server-side-encryption", "AES256");
            OutputStream outputStream = connection.getOutputStream();
            IOUtils.copy(stream, outputStream);
            connection.getResponseCode();
        }
        catch (MalformedURLException e) {
            throw new SdkClientException(e);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        UpdateDocumentVersionRequest updateDocumentVersionRequest = new UpdateDocumentVersionRequest();
        updateDocumentVersionRequest.setDocumentId(documentId);
        updateDocumentVersionRequest.setVersionId(versionId);
        updateDocumentVersionRequest.setVersionStatus(DocumentVersionStatus.ACTIVE);
        if (this.authenticationToken != null) {
            updateDocumentVersionRequest.setAuthenticationToken(this.authenticationToken);
        }
        UpdateDocumentVersionResult updateDocumentVersionResult = this.client.updateDocumentVersion(updateDocumentVersionRequest);
        UploadDocumentStreamResult uploadDocumentStreamResult = new UploadDocumentStreamResult(uploadDocumentStreamRequest);
        uploadDocumentStreamResult.setDocumentId(documentId);
        uploadDocumentStreamResult.setVersionId(versionId);
        return uploadDocumentStreamResult;
    }
}

