/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.protocol;

import com.amazonaws.thirdparty.apache.http.HttpException;
import com.amazonaws.thirdparty.apache.http.HttpResponse;
import com.amazonaws.thirdparty.apache.http.HttpResponseInterceptor;
import com.amazonaws.thirdparty.apache.http.annotation.ThreadSafe;
import com.amazonaws.thirdparty.apache.http.protocol.HttpContext;
import com.amazonaws.thirdparty.apache.http.protocol.HttpDateGenerator;
import com.amazonaws.thirdparty.apache.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

