/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.jackson.databind.ser.std;

import com.amazonaws.thirdparty.jackson.core.JsonGenerationException;
import com.amazonaws.thirdparty.jackson.core.JsonGenerator;
import com.amazonaws.thirdparty.jackson.databind.JavaType;
import com.amazonaws.thirdparty.jackson.databind.JsonMappingException;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.thirdparty.jackson.databind.SerializerProvider;
import com.amazonaws.thirdparty.jackson.databind.annotation.JacksonStdImpl;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.amazonaws.thirdparty.jackson.databind.ser.std.DateTimeSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;

@JacksonStdImpl
public class SqlDateSerializer
extends DateTimeSerializerBase<Date> {
    public SqlDateSerializer() {
        this(Boolean.FALSE);
    }

    protected SqlDateSerializer(Boolean useTimestamp) {
        super(Date.class, useTimestamp, null);
    }

    public SqlDateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new SqlDateSerializer(timestamp);
    }

    @Override
    protected long _timestamp(Date value) {
        return value == null ? 0L : value.getTime();
    }

    @Override
    public void serialize(Date value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._asTimestamp(provider)) {
            gen.writeNumber(this._timestamp(value));
        } else {
            gen.writeString(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._acceptJsonFormatVisitor(visitor, typeHint, this._useTimestamp);
    }
}

