/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ViewFsBaseTest;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsHdfs
extends ViewFsBaseTest {
    private static MiniDFSCluster cluster;
    private static final HdfsConfiguration CONF;
    private static FileContext fc;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper("/tmp/TestViewFsHdfs");
    }

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)CONF);
        Path defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fcTarget = fc;
        super.setUp();
    }

    int getExpectedDelegationTokenCount() {
        return 8;
    }

    @Test
    public void testTargetFileSystemLazyInitialization() throws Exception {
        FileContext otherfs2;
        final HashMap map = new HashMap();
        Path user1Path = new Path("/data/user1");
        FileContext fs = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
        fs.mkdir(user1Path, FileContext.DEFAULT_PERM, false);
        fs.delete(user1Path, false);
        UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user1@HADOOP.COM", (String[])new String[]{"hadoop"});
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                String doAsUserName = ugi.getUserName();
                Assert.assertEquals((Object)doAsUserName, (Object)"user1@HADOOP.COM");
                FileContext viewFS = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)TestViewFsHdfs.this.conf);
                map.put("user1", viewFS);
                return null;
            }
        });
        try {
            otherfs2 = (FileContext)map.get("user1");
            otherfs2.mkdir(user1Path, FileContext.DEFAULT_PERM, false);
            Assert.fail((String)"This mkdir should fail");
        }
        catch (AccessControlException otherfs2) {
            // empty catch block
        }
        this.fcView.setOwner(new Path("/data"), "user1", "test2");
        this.fcView.setPermission(new Path("/data"), new FsPermission("775"));
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileContext viewFS = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)TestViewFsHdfs.this.conf);
                map.put("user1", viewFS);
                return null;
            }
        });
        otherfs2 = (FileContext)map.get("user1");
        otherfs2.mkdir(user1Path, FileContext.DEFAULT_PERM, false);
        String owner = otherfs2.getFileStatus(user1Path).getOwner();
        Assert.assertEquals((String)"The owner did not match ", (Object)owner, (Object)userUgi.getShortUserName());
        otherfs2.delete(user1Path, false);
    }

    static {
        CONF = new HdfsConfiguration();
    }
}

