/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDistributedFileSystemWithECFile {
    private ErasureCodingPolicy ecPolicy;
    private int cellSize;
    private short dataBlocks;
    private short parityBlocks;
    private int numDNs;
    private int stripesPerBlock;
    private int blockSize;
    private int blockGroupSize;
    private MiniDFSCluster cluster;
    private FileContext fileContext;
    private DistributedFileSystem fs;
    private Configuration conf = new HdfsConfiguration();
    @Rule
    public final Timeout globalTimeout = new Timeout(180000);

    public ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setup() throws IOException {
        this.ecPolicy = this.getEcPolicy();
        this.cellSize = this.ecPolicy.getCellSize();
        this.dataBlocks = (short)this.ecPolicy.getNumDataUnits();
        this.parityBlocks = (short)this.ecPolicy.getNumParityUnits();
        this.numDNs = this.dataBlocks + this.parityBlocks;
        this.stripesPerBlock = 4;
        this.blockSize = this.stripesPerBlock * this.cellSize;
        this.blockGroupSize = this.blockSize * this.dataBlocks;
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.fileContext = FileContext.getFileContext((URI)this.cluster.getURI(0), (Configuration)this.conf);
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.fs.mkdirs(new Path("/ec"));
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/ec", this.ecPolicy.getName());
    }

    @After
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void createFile(String path, int size) throws Exception {
        byte[] expected = StripedFileTestUtil.generateBytes(size);
        Path src = new Path(path);
        DFSTestUtil.writeFile((FileSystem)this.fs, src, new String(expected));
        StripedFileTestUtil.waitBlockGroupsReported(this.fs, src.toString());
        StripedFileTestUtil.verifyLength((FileSystem)this.fs, src, size);
    }

    @Test(timeout=60000L)
    public void testListECFilesSmallerThanOneCell() throws Exception {
        this.createFile("/ec/smallcell", 1);
        ArrayList<Object> retVal = new ArrayList<Object>();
        RemoteIterator iter = this.cluster.getFileSystem().listFiles(new Path("/ec"), true);
        while (iter.hasNext()) {
            retVal.add(iter.next());
        }
        Assert.assertTrue((retVal.size() == 1 ? 1 : 0) != 0);
        LocatedFileStatus fileStatus = (LocatedFileStatus)retVal.get(0);
        this.assertSmallerThanOneCell(fileStatus.getBlockLocations());
        BlockLocation[] locations = this.cluster.getFileSystem().getFileBlockLocations((FileStatus)fileStatus, 0L, fileStatus.getLen());
        this.assertSmallerThanOneCell(locations);
        fileStatus = (LocatedFileStatus)this.fileContext.listLocatedStatus(new Path("/ec")).next();
        this.assertSmallerThanOneCell(fileStatus.getBlockLocations());
        locations = this.fileContext.getFileBlockLocations(new Path("/ec/smallcell"), 0L, fileStatus.getLen());
        this.assertSmallerThanOneCell(locations);
    }

    private void assertSmallerThanOneCell(BlockLocation[] locations) throws IOException {
        Assert.assertTrue((locations.length == 1 ? 1 : 0) != 0);
        BlockLocation blockLocation = locations[0];
        Assert.assertTrue((blockLocation.getOffset() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((blockLocation.getLength() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((blockLocation.getHosts().length == 1 + this.parityBlocks ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testListECFilesSmallerThanOneStripe() throws Exception {
        short dataBlocksNum = this.dataBlocks;
        this.createFile("/ec/smallstripe", this.cellSize * dataBlocksNum);
        RemoteIterator iter = this.cluster.getFileSystem().listFiles(new Path("/ec"), true);
        LocatedFileStatus fileStatus = (LocatedFileStatus)iter.next();
        this.assertSmallerThanOneStripe(fileStatus.getBlockLocations(), dataBlocksNum);
        BlockLocation[] locations = this.cluster.getFileSystem().getFileBlockLocations((FileStatus)fileStatus, 0L, fileStatus.getLen());
        this.assertSmallerThanOneStripe(locations, dataBlocksNum);
        fileStatus = (LocatedFileStatus)this.fileContext.listLocatedStatus(new Path("/ec")).next();
        this.assertSmallerThanOneStripe(fileStatus.getBlockLocations(), dataBlocksNum);
        locations = this.fileContext.getFileBlockLocations(new Path("/ec/smallstripe"), 0L, fileStatus.getLen());
        this.assertSmallerThanOneStripe(locations, dataBlocksNum);
    }

    private void assertSmallerThanOneStripe(BlockLocation[] locations, int dataBlocksNum) throws IOException {
        int expectedHostNum = dataBlocksNum + this.parityBlocks;
        Assert.assertTrue((locations.length == 1 ? 1 : 0) != 0);
        BlockLocation blockLocation = locations[0];
        Assert.assertTrue((blockLocation.getHosts().length == expectedHostNum ? 1 : 0) != 0);
        Assert.assertTrue((blockLocation.getOffset() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((blockLocation.getLength() == (long)(dataBlocksNum * this.cellSize) ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testListECFilesMoreThanOneBlockGroup() throws Exception {
        this.createFile("/ec/group", this.blockGroupSize + 123);
        RemoteIterator iter = this.cluster.getFileSystem().listFiles(new Path("/ec"), true);
        LocatedFileStatus fileStatus = (LocatedFileStatus)iter.next();
        this.assertMoreThanOneBlockGroup(fileStatus.getBlockLocations(), 123);
        BlockLocation[] locations = this.cluster.getFileSystem().getFileBlockLocations((FileStatus)fileStatus, 0L, fileStatus.getLen());
        this.assertMoreThanOneBlockGroup(locations, 123);
        iter = this.fileContext.listLocatedStatus(new Path("/ec"));
        fileStatus = (LocatedFileStatus)iter.next();
        this.assertMoreThanOneBlockGroup(fileStatus.getBlockLocations(), 123);
        locations = this.fileContext.getFileBlockLocations(new Path("/ec/group"), 0L, fileStatus.getLen());
        this.assertMoreThanOneBlockGroup(locations, 123);
    }

    private void assertMoreThanOneBlockGroup(BlockLocation[] locations, int lastBlockSize) throws IOException {
        Assert.assertTrue((locations.length == 2 ? 1 : 0) != 0);
        BlockLocation fistBlockGroup = locations[0];
        Assert.assertTrue((fistBlockGroup.getHosts().length == this.numDNs ? 1 : 0) != 0);
        Assert.assertTrue((fistBlockGroup.getOffset() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((fistBlockGroup.getLength() == (long)this.blockGroupSize ? 1 : 0) != 0);
        BlockLocation lastBlock = locations[1];
        Assert.assertTrue((lastBlock.getHosts().length == 1 + this.parityBlocks ? 1 : 0) != 0);
        Assert.assertTrue((lastBlock.getOffset() == (long)this.blockGroupSize ? 1 : 0) != 0);
        Assert.assertTrue((lastBlock.getLength() == (long)lastBlockSize ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testReplayEditLogsForReplicatedFile() throws Exception {
        this.cluster.shutdown();
        ErasureCodingPolicy rs63 = SystemErasureCodingPolicies.getByID((byte)1);
        ErasureCodingPolicy rs32 = SystemErasureCodingPolicies.getByID((byte)2);
        int numDataNodes = rs63.getNumDataUnits() + rs63.getNumParityUnits();
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(numDataNodes).build();
        this.cluster.transitionToActive(0);
        this.fs = this.cluster.getFileSystem(0);
        this.fs.enableErasureCodingPolicy(rs63.getName());
        this.fs.enableErasureCodingPolicy(rs32.getName());
        Path dir = new Path("/ec");
        this.fs.mkdirs(dir);
        this.fs.setErasureCodingPolicy(dir, rs63.getName());
        Path ecFile = new Path(dir, "ecFile");
        this.createFile(ecFile.toString(), 10);
        Path replicatedFile = new Path(dir, "replicated");
        try (FSDataOutputStream out = this.fs.createFile(replicatedFile).replicate().build();){
            out.write(123);
        }
        Path ecFile2 = new Path(dir, "RS-3-2");
        try (FSDataOutputStream out = this.fs.createFile(ecFile2).ecPolicyName(rs32.getName()).build();){
            out.write(456);
        }
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        this.fs = this.cluster.getFileSystem(1);
        Assert.assertNull((Object)this.fs.getErasureCodingPolicy(replicatedFile));
        Assert.assertEquals((Object)rs63, (Object)this.fs.getErasureCodingPolicy(ecFile));
        Assert.assertEquals((Object)rs32, (Object)this.fs.getErasureCodingPolicy(ecFile2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatistics() throws Exception {
        String fileName = "/ec/file";
        int size = 3200;
        this.createFile("/ec/file", 3200);
        FSDataInputStream in = null;
        try {
            in = this.fs.open(new Path("/ec/file"));
            IOUtils.copyBytes((InputStream)in, (OutputStream)System.out, (int)4096, (boolean)false);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
        Long totalBytesRead = 0L;
        Long ecBytesRead = 0L;
        for (FileSystem.Statistics stat : FileSystem.getAllStatistics()) {
            totalBytesRead = totalBytesRead + stat.getBytesRead();
            ecBytesRead = ecBytesRead + stat.getBytesReadErasureCoded();
        }
        Assert.assertEquals((Object)3200L, (Object)totalBytesRead);
        Assert.assertEquals((Object)3200L, (Object)ecBytesRead);
        Long totalBytesReadThread = 0L;
        Long ecBytesReadThread = 0L;
        for (FileSystem.Statistics stat : FileSystem.getAllStatistics()) {
            FileSystem.Statistics.StatisticsData data = stat.getThreadStatistics();
            totalBytesReadThread = totalBytesReadThread + data.getBytesRead();
            ecBytesReadThread = ecBytesReadThread + data.getBytesReadErasureCoded();
        }
        Assert.assertEquals((Object)3200L, (Object)totalBytesReadThread);
        Assert.assertEquals((Object)3200L, (Object)ecBytesReadThread);
    }
}

