/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.FileChecksumHelper;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFileChecksum {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileChecksum.class);
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private int dataBlocks = this.ecPolicy.getNumDataUnits();
    private int parityBlocks = this.ecPolicy.getNumParityUnits();
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private Configuration conf;
    private DFSClient client;
    private int cellSize = this.ecPolicy.getCellSize();
    private int stripesPerBlock = 6;
    private int blockSize = this.cellSize * this.stripesPerBlock;
    private int numBlockGroups = 10;
    private int stripSize = this.cellSize * this.dataBlocks;
    private int blockGroupSize = this.stripesPerBlock * this.stripSize;
    private int fileSize = this.numBlockGroups * this.blockGroupSize;
    private int bytesPerCRC;
    private String ecDir = "/striped";
    private String stripedFile1 = this.ecDir + "/stripedFileChecksum1";
    private String stripedFile2 = this.ecDir + "/stripedFileChecksum2";
    private String replicatedFile = "/replicatedFileChecksum";
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() throws IOException {
        int numDNs = this.dataBlocks + this.parityBlocks + 2;
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setInt("dfs.namenode.replication.max-streams", 0);
        this.conf.setBoolean("dfs.block.access.token.enable", true);
        this.customizeConf(this.conf);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDNs).build();
        Path ecPath = new Path(this.ecDir);
        this.cluster.getFileSystem().mkdir(ecPath, FsPermission.getDirDefault());
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy(this.ecDir, StripedFileTestUtil.getDefaultECPolicy().getName());
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        this.fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.bytesPerCRC = this.conf.getInt("dfs.bytes-per-checksum", 512);
        GenericTestUtils.setLogLevel((Logger)FileChecksumHelper.LOG, (Level)Level.DEBUG);
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    protected void customizeConf(Configuration preparedConf) {
    }

    protected boolean expectComparableStripedAndReplicatedFiles() {
        return false;
    }

    protected boolean expectComparableDifferentBlockSizeReplicatedFiles() {
        return false;
    }

    protected boolean expectSupportForSingleFileMixedBytesPerChecksum() {
        return false;
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum1() throws Exception {
        int length = 0;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, length + 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum2() throws Exception {
        int length = this.stripSize - 1;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum3() throws Exception {
        int length = this.stripSize;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum4() throws Exception {
        int length = this.stripSize + this.cellSize * 2;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum5() throws Exception {
        int length = this.blockGroupSize;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum6() throws Exception {
        int length = this.blockGroupSize + this.blockSize;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, length - 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksum7() throws Exception {
        int length = -1;
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        this.testStripedFileChecksum(length, this.fileSize);
    }

    private void testStripedFileChecksum(int range1, int range2) throws Exception {
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(this.stripedFile1, range1, false);
        FileChecksum stripedFileChecksum2 = this.getFileChecksum(this.stripedFile2, range1, false);
        FileChecksum stripedFileChecksum3 = this.getFileChecksum(this.stripedFile2, range2, false);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksum2:" + stripedFileChecksum2);
        LOG.info("stripedFileChecksum3:" + stripedFileChecksum3);
        Assert.assertTrue((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum2));
        if (range1 >= 0 && range1 != range2) {
            Assert.assertFalse((boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum3));
        }
    }

    @Test(timeout=90000L)
    public void testStripedAndReplicatedFileChecksum() throws Exception {
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.replicatedFile});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(this.stripedFile1, 10, false);
        FileChecksum replicatedFileChecksum = this.getFileChecksum(this.replicatedFile, 10, false);
        if (this.expectComparableStripedAndReplicatedFiles()) {
            Assert.assertEquals((Object)stripedFileChecksum1, (Object)replicatedFileChecksum);
        } else {
            Assert.assertNotEquals((Object)stripedFileChecksum1, (Object)replicatedFileChecksum);
        }
    }

    @Test(timeout=90000L)
    public void testDifferentBlockSizeReplicatedFileChecksum() throws Exception {
        byte[] fileData = StripedFileTestUtil.generateBytes(this.fileSize);
        String replicatedFile1 = "/replicatedFile1";
        String replicatedFile2 = "/replicatedFile2";
        DFSTestUtil.writeFile((FileSystem)this.fs, new Path(replicatedFile1), fileData, this.blockSize);
        DFSTestUtil.writeFile((FileSystem)this.fs, new Path(replicatedFile2), fileData, this.blockSize / 2);
        FileChecksum checksum1 = this.getFileChecksum(replicatedFile1, -1, false);
        FileChecksum checksum2 = this.getFileChecksum(replicatedFile2, -1, false);
        if (this.expectComparableDifferentBlockSizeReplicatedFiles()) {
            Assert.assertEquals((Object)checksum1, (Object)checksum2);
        } else {
            Assert.assertNotEquals((Object)checksum1, (Object)checksum2);
        }
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocks1() throws Exception {
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(this.stripedFile1, this.fileSize, false);
        FileChecksum stripedFileChecksumRecon = this.getFileChecksum(this.stripedFile1, this.fileSize, true);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksumRecon:" + stripedFileChecksumRecon);
        Assert.assertTrue((String)"Checksum mismatches!", (boolean)stripedFileChecksum1.equals((Object)stripedFileChecksumRecon));
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocks2() throws Exception {
        this.prepareTestFiles(this.fileSize, new String[]{this.stripedFile1, this.stripedFile2});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(this.stripedFile1, -1, false);
        FileChecksum stripedFileChecksum2 = this.getFileChecksum(this.stripedFile2, -1, false);
        FileChecksum stripedFileChecksum2Recon = this.getFileChecksum(this.stripedFile2, -1, true);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksum2:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksum2Recon:" + stripedFileChecksum2Recon);
        Assert.assertTrue((String)"Checksum mismatches!", (boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum2));
        Assert.assertTrue((String)"Checksum mismatches!", (boolean)stripedFileChecksum1.equals((Object)stripedFileChecksum2Recon));
        Assert.assertTrue((String)"Checksum mismatches!", (boolean)stripedFileChecksum2.equals((Object)stripedFileChecksum2Recon));
    }

    private void testStripedFileChecksumWithMissedDataBlocksRangeQuery(String stripedFile, int requestedLen) throws Exception {
        LOG.info("Checksum file:{}, requested length:{}", (Object)stripedFile, (Object)requestedLen);
        this.prepareTestFiles(this.fileSize, new String[]{stripedFile});
        FileChecksum stripedFileChecksum1 = this.getFileChecksum(stripedFile, requestedLen, false);
        FileChecksum stripedFileChecksumRecon = this.getFileChecksum(stripedFile, requestedLen, true);
        LOG.info("stripedFileChecksum1:" + stripedFileChecksum1);
        LOG.info("stripedFileChecksumRecon:" + stripedFileChecksumRecon);
        Assert.assertTrue((String)"Checksum mismatches!", (boolean)stripedFileChecksum1.equals((Object)stripedFileChecksumRecon));
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery1() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery2() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery3() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.bytesPerCRC);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery4() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.cellSize);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery5() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.cellSize - 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery6() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.cellSize + 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery7() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.cellSize * 2);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery8() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.stripSize);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery9() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.stripSize - 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery10() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.stripSize + 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery11() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.blockGroupSize - 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery12() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.blockGroupSize + 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery13() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.blockGroupSize * this.numBlockGroups / 2);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery14() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.fileSize - 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery15() throws Exception {
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(this.stripedFile1, this.fileSize * 2);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery16() throws Exception {
        int fileLength = 100;
        String stripedFile3 = this.ecDir + "/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, fileLength - 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery17() throws Exception {
        int fileLength = 100;
        String stripedFile3 = this.ecDir + "/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, 1);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery18() throws Exception {
        int fileLength = 100;
        String stripedFile3 = this.ecDir + "/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, 10);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery19() throws Exception {
        int fileLength = 100;
        String stripedFile3 = this.ecDir + "/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, fileLength * 2);
    }

    @Test(timeout=90000L)
    public void testStripedFileChecksumWithMissedDataBlocksRangeQuery20() throws Exception {
        int fileLength = this.bytesPerCRC;
        String stripedFile3 = this.ecDir + "/stripedFileChecksum3";
        this.prepareTestFiles(fileLength, new String[]{stripedFile3});
        this.testStripedFileChecksumWithMissedDataBlocksRangeQuery(stripedFile3, this.bytesPerCRC - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testStripedFileChecksumWithReconstructFail() throws Exception {
        String stripedFile4 = this.ecDir + "/stripedFileChecksum4";
        this.prepareTestFiles(this.fileSize, new String[]{stripedFile4});
        FileChecksum fileChecksum = this.getFileChecksum(stripedFile4, -1, false);
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector newInjector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
        ((DataNodeFaultInjector)Mockito.doThrow((Throwable)new IOException()).doNothing().when((Object)newInjector)).stripedBlockChecksumReconstruction();
        DataNodeFaultInjector.set((DataNodeFaultInjector)newInjector);
        try {
            FileChecksum fileChecksum1 = this.getFileChecksum(stripedFile4, -1, true);
            Assert.assertEquals((String)"checksum should be same", (Object)fileChecksum, (Object)fileChecksum1);
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }

    @Test(timeout=90000L)
    public void testMixedBytesPerChecksum() throws Exception {
        int fileLength = this.bytesPerCRC * 3;
        byte[] fileData = StripedFileTestUtil.generateBytes(fileLength);
        String replicatedFile1 = "/replicatedFile1";
        byte[] fileDataPart1 = new byte[this.bytesPerCRC * 2];
        System.arraycopy(fileData, 0, fileDataPart1, 0, fileDataPart1.length);
        byte[] fileDataPart2 = new byte[fileData.length - fileDataPart1.length];
        System.arraycopy(fileData, fileDataPart1.length, fileDataPart2, 0, fileDataPart2.length);
        DFSTestUtil.writeFile((FileSystem)this.fs, new Path(replicatedFile1), fileDataPart1);
        this.conf.setInt("dfs.bytes-per-checksum", this.bytesPerCRC / 2);
        DFSTestUtil.appendFileNewBlock((DistributedFileSystem)FileSystem.newInstance((Configuration)this.conf), new Path(replicatedFile1), fileDataPart2);
        if (this.expectSupportForSingleFileMixedBytesPerChecksum()) {
            String replicatedFile2 = "/replicatedFile2";
            DFSTestUtil.writeFile((FileSystem)this.fs, new Path(replicatedFile2), fileData);
            FileChecksum checksum1 = this.getFileChecksum(replicatedFile1, -1, false);
            FileChecksum checksum2 = this.getFileChecksum(replicatedFile2, -1, false);
            Assert.assertEquals((Object)checksum1, (Object)checksum2);
        } else {
            this.exception.expect(IOException.class);
            FileChecksum fileChecksum = this.getFileChecksum(replicatedFile1, -1, false);
        }
    }

    private FileChecksum getFileChecksum(String filePath, int range, boolean killDn) throws Exception {
        int dnIdxToDie = -1;
        if (killDn) {
            dnIdxToDie = this.getDataNodeToKill(filePath);
            DataNode dnToDie = this.cluster.getDataNodes().get(dnIdxToDie);
            this.shutdownDataNode(dnToDie);
        }
        Path testPath = new Path(filePath);
        FileChecksum fc = range >= 0 ? this.fs.getFileChecksum(testPath, (long)range) : this.fs.getFileChecksum(testPath);
        if (dnIdxToDie != -1) {
            this.cluster.restartDataNode(dnIdxToDie);
        }
        return fc;
    }

    private void prepareTestFiles(int fileLength, String[] filePaths) throws IOException {
        byte[] fileData = StripedFileTestUtil.generateBytes(fileLength);
        for (String filePath : filePaths) {
            Path testPath = new Path(filePath);
            DFSTestUtil.writeFile((FileSystem)this.fs, testPath, fileData);
        }
    }

    void shutdownDataNode(DataNode dataNode) throws IOException {
        dataNode.shutdown();
        this.cluster.setDataNodeDead(dataNode.getDatanodeId());
    }

    int getDataNodeToKill(String filePath) throws IOException {
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(filePath, 0L);
        LocatedBlock locatedBlock = locatedBlocks.get(0);
        DatanodeInfo[] datanodes = locatedBlock.getLocations();
        DatanodeInfo chosenDn = datanodes[new Random().nextInt(datanodes.length)];
        int idx = 0;
        for (DataNode dn : this.cluster.getDataNodes()) {
            if (dn.getInfoPort() == chosenDn.getInfoPort()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

