/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.junit.Assert;
import org.junit.Test;

public class TestRefreshNamenodes {
    private final int nnPort1 = 2221;
    private final int nnPort2 = 2224;
    private final int nnPort3 = 2227;
    private final int nnPort4 = 2230;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshNamenodes() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf(null).setIpcPort(2221))).setFederation(true);
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).build();
            DataNode dn = cluster.getDataNodes().get(0);
            Assert.assertEquals((long)1L, (long)dn.getAllBpOs().size());
            cluster.addNameNode(conf, 2224);
            Assert.assertEquals((long)2L, (long)dn.getAllBpOs().size());
            cluster.addNameNode(conf, 2227);
            Assert.assertEquals((long)3L, (long)dn.getAllBpOs().size());
            cluster.addNameNode(conf, 2230);
            HashSet nnAddrsFromCluster = Sets.newHashSet();
            for (int i = 0; i < 4; ++i) {
                Assert.assertTrue((boolean)nnAddrsFromCluster.add(cluster.getNameNode(i).getNameNodeAddress()));
            }
            HashSet nnAddrsFromDN = Sets.newHashSet();
            for (BPOfferService bpos : dn.getAllBpOs()) {
                for (BPServiceActor bpsa : bpos.getBPServiceActors()) {
                    Assert.assertTrue((boolean)nnAddrsFromDN.add(bpsa.getNNSocketAddress()));
                }
            }
            Assert.assertEquals((Object)"", (Object)Joiner.on((String)",").join((Iterable)Sets.symmetricDifference((Set)nnAddrsFromCluster, (Set)nnAddrsFromDN)));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRefreshNameNodeDeadLock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector(){

                public void delayWhenOfferServiceHoldLock() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            DataNode dn = cluster.getDataNodes().get(0);
            Configuration dnConf = dn.getConf();
            dnConf.set("dfs.nameservices", "ns1");
            dnConf.set("dfs.namenode.lifeline.rpc-address.ns1", "mock:8022");
            dn.refreshNamenodes(dnConf);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

