/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestAddStripedBlocks {
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final short groupSize = (short)(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits());
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.groupSize).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.dfs.getClient().setErasureCodingPolicy("/", this.ecPolicy.getName());
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testBlockScheduledUpdate() throws Exception {
        FSNamesystem fsn = this.cluster.getNamesystem();
        Path foo = new Path("/foo");
        FSDataOutputStream out = this.dfs.create(foo, true);
        Object object = null;
        try {
            DFSStripedOutputStream sout = (DFSStripedOutputStream)out.getWrappedStream();
            TestAddStripedBlocks.writeAndFlushStripedOutputStream(sout, 512);
            ArrayList dnList = new ArrayList();
            fsn.getBlockManager().getDatanodeManager().fetchDatanodes(dnList, null, false);
            for (DatanodeDescriptor dn : dnList) {
                Assert.assertEquals((long)1L, (long)dn.getBlocksScheduled());
            }
        }
        catch (Throwable sout) {
            object = sout;
            throw sout;
        }
        finally {
            if (out != null) {
                if (object != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable sout) {
                        ((Throwable)object).addSuppressed(sout);
                    }
                } else {
                    out.close();
                }
            }
        }
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(dn);
        }
        ArrayList dnList = new ArrayList();
        fsn.getBlockManager().getDatanodeManager().fetchDatanodes(dnList, null, false);
        for (DatanodeDescriptor dn : dnList) {
            Assert.assertEquals((long)0L, (long)dn.getBlocksScheduled());
        }
    }

    @Test
    public void testAllocateBlockId() throws Exception {
        Path testPath = new Path("/testfile");
        DFSTestUtil.writeFile((FileSystem)this.dfs, testPath, "hello, world!");
        LocatedBlocks lb = this.dfs.getClient().getLocatedBlocks(testPath.toString(), 0L);
        long firstId = lb.get(0).getBlock().getBlockId();
        this.dfs.delete(testPath, true);
        DFSTestUtil.writeFile((FileSystem)this.dfs, testPath, "hello again");
        lb = this.dfs.getClient().getLocatedBlocks(testPath.toString(), 0L);
        long secondId = lb.get(0).getBlock().getBlockId();
        Assert.assertEquals((long)(firstId + 16L), (long)secondId);
    }

    private static void writeAndFlushStripedOutputStream(DFSStripedOutputStream out, int chunkSize) throws IOException {
        byte[] toWrite = new byte[chunkSize * 9 + 1];
        out.write(toWrite);
        DFSTestUtil.flushInternal(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAddStripedBlock() throws Exception {
        Path file = new Path("/file1");
        FSDataOutputStream out = null;
        try {
            out = this.dfs.create(file, (short)1);
            TestAddStripedBlocks.writeAndFlushStripedOutputStream((DFSStripedOutputStream)out.getWrappedStream(), 512);
            FSDirectory fsdir = this.cluster.getNamesystem().getFSDirectory();
            INodeFile fileNode = fsdir.getINode4Write(file.toString()).asFile();
            BlockInfo[] blocks = fileNode.getBlocks();
            Assert.assertEquals((long)1L, (long)blocks.length);
            Assert.assertTrue((boolean)blocks[0].isStriped());
            this.checkStripedBlockUC((BlockInfoStriped)fileNode.getLastBlock(), true);
            this.cluster.restartNameNode(true);
            fsdir = this.cluster.getNamesystem().getFSDirectory();
            fileNode = fsdir.getINode4Write(file.toString()).asFile();
            blocks = fileNode.getBlocks();
            Assert.assertEquals((long)1L, (long)blocks.length);
            Assert.assertTrue((boolean)blocks[0].isStriped());
            this.checkStripedBlockUC((BlockInfoStriped)fileNode.getLastBlock(), false);
            this.dfs = this.cluster.getFileSystem();
            this.dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            this.dfs.saveNamespace();
            this.dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            this.cluster.restartNameNode(true);
            fsdir = this.cluster.getNamesystem().getFSDirectory();
            fileNode = fsdir.getINode4Write(file.toString()).asFile();
            blocks = fileNode.getBlocks();
            Assert.assertEquals((long)1L, (long)blocks.length);
            Assert.assertTrue((boolean)blocks[0].isStriped());
            this.checkStripedBlockUC((BlockInfoStriped)fileNode.getLastBlock(), false);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }

    private void checkStripedBlockUC(BlockInfoStriped block, boolean checkReplica) {
        Assert.assertEquals((long)0L, (long)block.numNodes());
        Assert.assertFalse((boolean)block.isComplete());
        Assert.assertEquals((long)this.dataBlocks, (long)block.getDataBlockNum());
        Assert.assertEquals((long)this.parityBlocks, (long)block.getParityBlockNum());
        Assert.assertEquals((long)0L, (long)(block.getBlockId() & 0xFL));
        Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, (Object)block.getBlockUCState());
        if (checkReplica) {
            Assert.assertEquals((long)this.groupSize, (long)block.getUnderConstructionFeature().getNumExpectedLocations());
            DatanodeStorageInfo[] storages = block.getUnderConstructionFeature().getExpectedStorageLocations();
            for (DataNode dn : this.cluster.getDataNodes()) {
                Assert.assertTrue((boolean)this.includeDataNode(dn.getDatanodeId(), storages));
            }
        }
    }

    private boolean includeDataNode(DatanodeID dn, DatanodeStorageInfo[] storages) {
        for (DatanodeStorageInfo storage : storages) {
            if (!storage.getDatanodeDescriptor().equals((Object)dn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetLocatedStripedBlocks() throws Exception {
        Path file = new Path("/file1");
        FSDataOutputStream out = null;
        try {
            out = this.dfs.create(file, (short)1);
            TestAddStripedBlocks.writeAndFlushStripedOutputStream((DFSStripedOutputStream)out.getWrappedStream(), 512);
            FSDirectory fsdir = this.cluster.getNamesystem().getFSDirectory();
            INodeFile fileNode = fsdir.getINode4Write(file.toString()).asFile();
            BlockInfoStriped lastBlk = (BlockInfoStriped)fileNode.getLastBlock();
            Object[] expectedDNs = DatanodeStorageInfo.toDatanodeInfos((DatanodeStorageInfo[])lastBlk.getUnderConstructionFeature().getExpectedStorageLocations());
            byte[] indices = lastBlk.getUnderConstructionFeature().getBlockIndices();
            LocatedBlocks blks = this.dfs.getClient().getLocatedBlocks(file.toString(), 0L);
            Assert.assertEquals((long)1L, (long)blks.locatedBlockCount());
            LocatedBlock lblk = blks.get(0);
            Assert.assertTrue((boolean)(lblk instanceof LocatedStripedBlock));
            Object[] datanodes = lblk.getLocations();
            byte[] blockIndices = ((LocatedStripedBlock)lblk).getBlockIndices();
            Assert.assertEquals((long)this.groupSize, (long)datanodes.length);
            Assert.assertEquals((long)this.groupSize, (long)blockIndices.length);
            Assert.assertArrayEquals((byte[])indices, (byte[])blockIndices);
            Assert.assertArrayEquals((Object[])expectedDNs, (Object[])datanodes);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUCReplica() throws Exception {
        Object indices;
        BlockInfo lastBlock;
        INodeFile fileNode;
        Path file = new Path("/file1");
        ArrayList<String> storageIDs = new ArrayList<String>();
        FSDataOutputStream out = null;
        try {
            out = this.dfs.create(file, (short)1);
            FSDirectory fsdir = this.cluster.getNamesystem().getFSDirectory();
            fileNode = fsdir.getINode4Write(file.toString()).asFile();
            this.cluster.getNamesystem().getAdditionalBlock(file.toString(), fileNode.getId(), this.dfs.getClient().getClientName(), null, null, null, null);
            lastBlock = fileNode.getLastBlock();
            DatanodeStorageInfo[] locs = lastBlock.getUnderConstructionFeature().getExpectedStorageLocations();
            indices = lastBlock.getUnderConstructionFeature().getBlockIndices();
            Assert.assertEquals((long)this.groupSize, (long)locs.length);
            Assert.assertEquals((long)this.groupSize, (long)((byte[])indices).length);
            int i = 0;
            for (DataNode dn : this.cluster.getDataNodes()) {
                StorageReceivedDeletedBlocks[] reports;
                Block block = new Block(lastBlock.getBlockId() + (long)i++, 0L, lastBlock.getGenerationStamp());
                DatanodeStorage storage = new DatanodeStorage(UUID.randomUUID().toString());
                storageIDs.add(storage.getStorageID());
                for (StorageReceivedDeletedBlocks report : reports = DFSTestUtil.makeReportForReceivedBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, storage)) {
                    this.cluster.getNamesystem().processIncrementalBlockReport(dn.getDatanodeId(), report);
                }
            }
            locs = lastBlock.getUnderConstructionFeature().getExpectedStorageLocations();
            indices = lastBlock.getUnderConstructionFeature().getBlockIndices();
            Assert.assertEquals((long)this.groupSize, (long)locs.length);
            Assert.assertEquals((long)this.groupSize, (long)((byte[])indices).length);
            for (DatanodeStorageInfo newstorage : locs) {
                Assert.assertTrue((boolean)storageIDs.contains(newstorage.getStorageID()));
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
        this.cluster.restartNameNode(true);
        String bpId = this.cluster.getNamesystem().getBlockPoolId();
        fileNode = this.cluster.getNamesystem().getFSDirectory().getINode4Write(file.toString()).asFile();
        lastBlock = fileNode.getLastBlock();
        int i = this.groupSize - 1;
        indices = this.cluster.getDataNodes().iterator();
        while (indices.hasNext()) {
            DataNode dn = (DataNode)indices.next();
            String storageID = (String)storageIDs.get(i);
            Block block = new Block(lastBlock.getBlockId() + (long)i--, 0L, lastBlock.getGenerationStamp());
            DatanodeStorage storage = new DatanodeStorage(storageID);
            ArrayList<ReplicaBeingWritten> blocks = new ArrayList<ReplicaBeingWritten>();
            ReplicaBeingWritten replica = new ReplicaBeingWritten(block, null, null, null);
            blocks.add(replica);
            BlockListAsLongs bll = BlockListAsLongs.encode(blocks);
            StorageBlockReport[] reports = new StorageBlockReport[]{new StorageBlockReport(storage, bll)};
            this.cluster.getNameNodeRpc().blockReport(dn.getDNRegistrationForBP(bpId), bpId, reports, null);
        }
        DatanodeStorageInfo[] locs = lastBlock.getUnderConstructionFeature().getExpectedStorageLocations();
        byte[] indices2 = lastBlock.getUnderConstructionFeature().getBlockIndices();
        Assert.assertEquals((long)this.groupSize, (long)locs.length);
        Assert.assertEquals((long)this.groupSize, (long)indices2.length);
        for (i = 0; i < this.groupSize; ++i) {
            Assert.assertEquals(storageIDs.get(i), (Object)locs[this.groupSize - 1 - i].getStorageID());
            Assert.assertEquals((long)(this.groupSize - i - 1), (long)indices2[i]);
        }
    }

    @Test
    public void testCheckStripedReplicaCorrupt() throws Exception {
        int numBlocks = 4;
        int numStripes = 4;
        Path filePath = new Path("/corrupt");
        FSNamesystem ns = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = ns.getBlockManager();
        DFSTestUtil.createStripedFile(this.cluster, filePath, null, 4, 4, false);
        INodeFile fileNode = ns.getFSDirectory().getINode(filePath.toString()).asFile();
        Assert.assertTrue((boolean)fileNode.isStriped());
        BlockInfo stored = fileNode.getBlocks()[0];
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)0L, (long)ns.getCorruptReplicaBlocks());
        DatanodeStorage storage = new DatanodeStorage(UUID.randomUUID().toString());
        Block reported = new Block((Block)stored);
        reported.setNumBytes((long)(4 * this.cellSize));
        StorageReceivedDeletedBlocks[] reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(0).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)0L, (long)ns.getCorruptReplicaBlocks());
        reported.setBlockId(stored.getBlockId() + 1L);
        reported.setNumBytes((long)(4 * this.cellSize - 1));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(1).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        reported.setBlockId(stored.getBlockId() + (long)this.dataBlocks);
        reported.setNumBytes((long)(4 * this.cellSize));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(2).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        reported.setBlockId(stored.getBlockId() + (long)this.dataBlocks);
        reported.setNumBytes((long)(4 * this.cellSize + 1));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(3).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptECBlockGroups());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        Assert.assertEquals((long)0L, (long)ns.getCorruptReplicatedBlocks());
        Assert.assertEquals((long)2L, (long)bm.getCorruptReplicas((Block)stored).size());
        stored.setNumBytes(stored.getNumBytes() + 10L);
        reported.setBlockId(stored.getBlockId() + (long)this.dataBlocks + 2L);
        reported.setNumBytes((long)(4 * this.cellSize));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(4).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        Assert.assertEquals((long)3L, (long)bm.getCorruptReplicas((Block)stored).size());
        stored.setNumBytes(stored.getNumBytes() + (long)this.cellSize);
        reported.setBlockId(stored.getBlockId());
        reported.setNumBytes((long)(5 * this.cellSize));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(0).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        Assert.assertEquals((long)3L, (long)bm.getCorruptReplicas((Block)stored).size());
        reported.setBlockId(stored.getBlockId() + 1L);
        reported.setNumBytes((long)(4 * this.cellSize + 10));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(0).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        Assert.assertEquals((long)3L, (long)bm.getCorruptReplicas((Block)stored).size());
        reported.setBlockId(stored.getBlockId() + (long)this.dataBlocks);
        reported.setNumBytes((long)(5 * this.cellSize));
        reports = DFSTestUtil.makeReportForReceivedBlock(reported, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage);
        ns.processIncrementalBlockReport(this.cluster.getDataNodes().get(2).getDatanodeId(), reports[0]);
        BlockManagerTestUtil.updateState(ns.getBlockManager());
        Assert.assertEquals((long)1L, (long)ns.getCorruptReplicaBlocks());
        Assert.assertEquals((long)3L, (long)bm.getCorruptReplicas((Block)stored).size());
    }
}

