/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagedParentQueue
extends ParentQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractManagedParentQueue.class);
    protected AutoCreatedLeafQueueConfig leafQueueTemplate;
    protected AutoCreatedQueueManagementPolicy queueManagementPolicy = null;

    public AbstractManagedParentQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
    }

    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            this.setupQueueConfigs(clusterResource);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addChildQueue(CSQueue childQueue) throws SchedulerDynamicEditException, IOException {
        try {
            this.writeLock.lock();
            if (childQueue.getCapacity() > 0.0f) {
                throw new SchedulerDynamicEditException("Queue " + childQueue + " being added has non zero capacity.");
            }
            boolean added = this.childQueues.add(childQueue);
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateChildQueues (action: add queue): " + added + " " + this.getChildQueuesToPrint());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildQueue(CSQueue childQueue) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            if (childQueue.getCapacity() > 0.0f) {
                throw new SchedulerDynamicEditException("Queue " + childQueue + " being removed has non zero capacity.");
            }
            Iterator qiter = this.childQueues.iterator();
            while (qiter.hasNext()) {
                CSQueue cs = (CSQueue)qiter.next();
                if (!cs.equals(childQueue)) continue;
                qiter.remove();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Removed child queue: {}" + cs.getQueueName());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public CSQueue removeChildQueue(String childQueueName) throws SchedulerDynamicEditException {
        CSQueue childQueue;
        block4: {
            try {
                this.writeLock.lock();
                childQueue = this.csContext.getCapacitySchedulerQueueManager().getQueue(childQueueName);
                if (childQueue != null) {
                    this.removeChildQueue(childQueue);
                    break block4;
                }
                throw new SchedulerDynamicEditException("Cannot find queue to delete : " + childQueueName);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return childQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float sumOfChildCapacities() {
        try {
            this.writeLock.lock();
            float ret = 0.0f;
            for (CSQueue l : this.childQueues) {
                ret += l.getCapacity();
            }
            float f = ret;
            return f;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float sumOfChildAbsCapacities() {
        try {
            this.writeLock.lock();
            float ret = 0.0f;
            for (CSQueue l : this.childQueues) {
                ret += l.getAbsoluteCapacity();
            }
            float f = ret;
            return f;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public AutoCreatedLeafQueueConfig getLeafQueueTemplate() {
        return this.leafQueueTemplate;
    }

    public AutoCreatedQueueManagementPolicy getAutoCreatedQueueManagementPolicy() {
        return this.queueManagementPolicy;
    }

    protected SortedMap<String, String> getConfigurationsWithPrefix(SortedMap<String, String> sortedConfigs, String prefix) {
        return sortedConfigs.subMap(prefix, prefix + '\uffff');
    }

    protected SortedMap<String, String> sortCSConfigurations() {
        TreeMap<String, String> sortedConfigs = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        Iterator iterator = this.csContext.getConfiguration().iterator();
        while (iterator.hasNext()) {
            Map.Entry confKeyValuePair = (Map.Entry)iterator.next();
            sortedConfigs.put((String)confKeyValuePair.getKey(), (String)confKeyValuePair.getValue());
        }
        return sortedConfigs;
    }

    protected CapacitySchedulerConfiguration initializeLeafQueueConfigs(String configPrefix) {
        CapacitySchedulerConfiguration leafQueueConfigs = new CapacitySchedulerConfiguration(new Configuration(false), false);
        SortedMap<String, String> sortedConfigs = this.sortCSConfigurations();
        SortedMap<String, String> templateConfigs = this.getConfigurationsWithPrefix(sortedConfigs, configPrefix);
        for (Map.Entry<String, String> confKeyValuePair : templateConfigs.entrySet()) {
            leafQueueConfigs.set(confKeyValuePair.getKey(), confKeyValuePair.getValue());
        }
        return leafQueueConfigs;
    }

    protected void validateQueueEntitlementChange(AbstractAutoCreatedLeafQueue leafQueue, QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        float sumChilds = this.sumOfChildCapacities();
        float newChildCap = sumChilds - leafQueue.getCapacity() + entitlement.getCapacity();
        if (!(newChildCap >= 0.0f) || !(newChildCap < 1.0001f)) {
            throw new SchedulerDynamicEditException("Sum of child queues should exceed 100% for auto creating parent queue : " + this.queueName);
        }
    }
}

