/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Arrays;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ActiveSetSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;

abstract class DirectASS
extends ActiveSetSolver {
    DirectASS(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected void performIteration() {
        int i;
        if (this.isDebug()) {
            this.debug("\nPerformIteration {}", 1 + this.countIterations());
            this.debug(this.myActivator.toString(), new Object[0]);
        }
        this.myConstraintToInclude = -1;
        int[] tmpIncluded = this.myActivator.getIncluded();
        this.getIterationQ();
        MatrixStore<Double> tmpIterC = this.getIterationC();
        MatrixStore<Double> tmpIterA = this.getIterationA(tmpIncluded);
        MatrixStore<Double> tmpIterB = this.getIterationB(tmpIncluded);
        boolean tmpSolvable = false;
        PrimitiveDenseStore tmpIterX = this.myIterationX;
        PrimitiveDenseStore tmpIterL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpIterA.countRows(), 1L);
        if (tmpIterA.countRows() < tmpIterA.countColumns() && (tmpSolvable = this.myCholesky.isSolvable())) {
            if (tmpIterA.countRows() == 0L) {
                this.myCholesky.getSolution(tmpIterC, tmpIterX);
            } else {
                MatrixStore<Double> tmpInvQAT = this.myCholesky.getSolution(tmpIterA.transpose());
                ElementsSupplier<Double> tmpS = tmpInvQAT.premultiply(tmpIterA);
                if (this.isDebug()) {
                    BasicLogger.debug(Arrays.toString(tmpIncluded), tmpS.get());
                }
                if (tmpSolvable = this.myLU.compute(tmpS)) {
                    this.myLU.getSolution(this.myInvQC.premultiply(tmpIterA).operateOnMatching((BinaryFunction<Double>)PrimitiveFunction.SUBTRACT, tmpIterB), tmpIterL);
                    if (this.isDebug()) {
                        this.debug("Iteration L", tmpIterL);
                    }
                    this.myCholesky.getSolution(tmpIterL.premultiply(tmpIterA.transpose()).operateOnMatching(tmpIterC, (BinaryFunction<Double>)PrimitiveFunction.SUBTRACT), tmpIterX);
                }
            }
        }
        if (!tmpSolvable && (tmpSolvable = this.myLU.compute(this.getIterationKKT(tmpIncluded)))) {
            MatrixStore tmpXL = this.myLU.getSolution(this.getIterationRHS(tmpIncluded));
            tmpIterX.fillMatching((MatrixStore<Double>)tmpXL.logical().limits(this.countVariables(), (int)tmpXL.countColumns()).get());
            tmpIterL.fillMatching((MatrixStore<Double>)tmpXL.logical().offsets(this.countVariables(), 0).get());
        }
        if (!tmpSolvable && this.isDebug()) {
            this.options.debug_appender.println("KKT system unsolvable!");
            this.options.debug_appender.printmtrx("KKT", this.getIterationKKT());
            this.options.debug_appender.printmtrx("RHS", this.getIterationRHS());
        }
        this.myIterationL.fillAll(0.0);
        int tmpCountE = this.countEqualityConstraints();
        for (i = 0; i < tmpCountE; ++i) {
            this.myIterationL.set((long)i, tmpIterL.doubleValue((long)i));
        }
        for (i = 0; i < tmpIncluded.length; ++i) {
            this.myIterationL.set((long)(tmpCountE + tmpIncluded[i]), tmpIterL.doubleValue((long)(tmpCountE + i)));
        }
        this.handleSubsolution(tmpSolvable, tmpIterX, tmpIncluded);
    }

    @Override
    void excludeAndRemove(int toExclude) {
        this.myActivator.exclude(toExclude);
    }

    @Override
    void initSolution(MatrixStore<Double> tmpBI, int tmpNumVars, int tmpNumEqus) {
        if (this.hasInequalityConstraints()) {
            int[] tmpExcluded = this.myActivator.getExcluded();
            MatrixStore<Double> tmpAIX = this.getAIX(tmpExcluded);
            for (int i = 0; i < tmpExcluded.length; ++i) {
                double tmpBody = tmpAIX.doubleValue(i);
                double tmpRHS = tmpBI.doubleValue(tmpExcluded[i]);
                if (this.options.slack.isDifferent(tmpRHS, tmpBody) || this.myIterationL.doubleValue((long)(tmpNumEqus + tmpExcluded[i])) == PrimitiveMath.ZERO) continue;
                this.myActivator.include(tmpExcluded[i]);
            }
        }
        while (tmpNumEqus + this.myActivator.countIncluded() >= tmpNumVars && this.myActivator.countIncluded() > 0) {
            this.shrink();
        }
        if (this.isDebug() && tmpNumEqus + this.myActivator.countIncluded() > tmpNumVars) {
            this.debug("Redundant contraints!", new Object[0]);
        }
        this.myInvQC = this.myCholesky.getSolution(this.getIterationC());
    }
}

