/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeLifelineProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.protocol.DatanodeLifelineProtocol;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.shaded.com.google.protobuf.ServiceException;

@InterfaceAudience.Private
public class DatanodeLifelineProtocolServerSideTranslatorPB
implements DatanodeLifelineProtocolPB {
    private static final DatanodeLifelineProtocolProtos.LifelineResponseProto VOID_LIFELINE_RESPONSE_PROTO = DatanodeLifelineProtocolProtos.LifelineResponseProto.newBuilder().build();
    private final DatanodeLifelineProtocol impl;

    public DatanodeLifelineProtocolServerSideTranslatorPB(DatanodeLifelineProtocol impl) {
        this.impl = impl;
    }

    @Override
    public DatanodeLifelineProtocolProtos.LifelineResponseProto sendLifeline(RpcController controller, DatanodeProtocolProtos.HeartbeatRequestProto request) throws ServiceException {
        try {
            StorageReport[] report = PBHelperClient.convertStorageReports(request.getReportsList());
            VolumeFailureSummary volumeFailureSummary = request.hasVolumeFailureSummary() ? PBHelper.convertVolumeFailureSummary(request.getVolumeFailureSummary()) : null;
            this.impl.sendLifeline(PBHelper.convert(request.getRegistration()), report, request.getCacheCapacity(), request.getCacheUsed(), request.getXmitsInProgress(), request.getXceiverCount(), request.getFailedVolumes(), volumeFailureSummary);
            return VOID_LIFELINE_RESPONSE_PROTO;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

